/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Capture;
import com.paypal.api.payments.FmfDetails;
import com.paypal.api.payments.Links;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.List;

public class Authorization
extends PayPalResource {
    private String id;
    private Amount amount;
    private String paymentMode;
    private String state;
    private String reasonCode;
    private String pendingReason;
    private String protectionEligibility;
    private String protectionEligibilityType;
    private FmfDetails fmfDetails;
    private String parentPayment;
    private String validUntil;
    private String createTime;
    private String updateTime;
    private List<Links> links;

    public Authorization() {
    }

    public Authorization(Amount amount) {
        this.amount = amount;
    }

    public static Authorization get(String accessToken, String authorizationId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Authorization.get(apiContext, authorizationId);
    }

    public static Authorization get(APIContext apiContext, String authorizationId) throws PayPalRESTException {
        if (authorizationId == null) {
            throw new IllegalArgumentException("authorizationId cannot be null");
        }
        Object[] parameters = new Object[]{authorizationId};
        String pattern = "v1/payments/authorization/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Authorization.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Authorization.class);
    }

    public Capture capture(String accessToken, Capture capture) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.capture(apiContext, capture);
    }

    public Capture capture(APIContext apiContext, Capture capture) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (capture == null) {
            throw new IllegalArgumentException("capture cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/authorization/{0}/capture";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = capture.toJSON();
        return Authorization.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Capture.class);
    }

    public Authorization doVoid(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.doVoid(apiContext);
    }

    public Authorization doVoid(APIContext apiContext) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/authorization/{0}/void";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Authorization.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Authorization.class);
    }

    public Authorization reauthorize(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.reauthorize(apiContext);
    }

    public Authorization reauthorize(APIContext apiContext) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/authorization/{0}/reauthorize";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = this.toJSON();
        return Authorization.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Authorization.class);
    }

    public String getId() {
        return this.id;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public String getState() {
        return this.state;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public String getPendingReason() {
        return this.pendingReason;
    }

    public String getProtectionEligibility() {
        return this.protectionEligibility;
    }

    public String getProtectionEligibilityType() {
        return this.protectionEligibilityType;
    }

    public FmfDetails getFmfDetails() {
        return this.fmfDetails;
    }

    public String getParentPayment() {
        return this.parentPayment;
    }

    public String getValidUntil() {
        return this.validUntil;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Authorization setId(String id) {
        this.id = id;
        return this;
    }

    public Authorization setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Authorization setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
        return this;
    }

    public Authorization setState(String state) {
        this.state = state;
        return this;
    }

    public Authorization setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    public Authorization setPendingReason(String pendingReason) {
        this.pendingReason = pendingReason;
        return this;
    }

    public Authorization setProtectionEligibility(String protectionEligibility) {
        this.protectionEligibility = protectionEligibility;
        return this;
    }

    public Authorization setProtectionEligibilityType(String protectionEligibilityType) {
        this.protectionEligibilityType = protectionEligibilityType;
        return this;
    }

    public Authorization setFmfDetails(FmfDetails fmfDetails) {
        this.fmfDetails = fmfDetails;
        return this;
    }

    public Authorization setParentPayment(String parentPayment) {
        this.parentPayment = parentPayment;
        return this;
    }

    public Authorization setValidUntil(String validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public Authorization setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public Authorization setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public Authorization setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Authorization)) {
            return false;
        }
        Authorization other = (Authorization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Amount this$amount = this.getAmount();
        Amount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$paymentMode = this.getPaymentMode();
        String other$paymentMode = other.getPaymentMode();
        if (this$paymentMode == null ? other$paymentMode != null : !this$paymentMode.equals(other$paymentMode)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$reasonCode = this.getReasonCode();
        String other$reasonCode = other.getReasonCode();
        if (this$reasonCode == null ? other$reasonCode != null : !this$reasonCode.equals(other$reasonCode)) {
            return false;
        }
        String this$pendingReason = this.getPendingReason();
        String other$pendingReason = other.getPendingReason();
        if (this$pendingReason == null ? other$pendingReason != null : !this$pendingReason.equals(other$pendingReason)) {
            return false;
        }
        String this$protectionEligibility = this.getProtectionEligibility();
        String other$protectionEligibility = other.getProtectionEligibility();
        if (this$protectionEligibility == null ? other$protectionEligibility != null : !this$protectionEligibility.equals(other$protectionEligibility)) {
            return false;
        }
        String this$protectionEligibilityType = this.getProtectionEligibilityType();
        String other$protectionEligibilityType = other.getProtectionEligibilityType();
        if (this$protectionEligibilityType == null ? other$protectionEligibilityType != null : !this$protectionEligibilityType.equals(other$protectionEligibilityType)) {
            return false;
        }
        FmfDetails this$fmfDetails = this.getFmfDetails();
        FmfDetails other$fmfDetails = other.getFmfDetails();
        if (this$fmfDetails == null ? other$fmfDetails != null : !((Object)this$fmfDetails).equals(other$fmfDetails)) {
            return false;
        }
        String this$parentPayment = this.getParentPayment();
        String other$parentPayment = other.getParentPayment();
        if (this$parentPayment == null ? other$parentPayment != null : !this$parentPayment.equals(other$parentPayment)) {
            return false;
        }
        String this$validUntil = this.getValidUntil();
        String other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !this$validUntil.equals(other$validUntil)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        List<Links> this$links = this.getLinks();
        List<Links> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Authorization;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Amount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $paymentMode = this.getPaymentMode();
        result = result * 59 + ($paymentMode == null ? 43 : $paymentMode.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $reasonCode = this.getReasonCode();
        result = result * 59 + ($reasonCode == null ? 43 : $reasonCode.hashCode());
        String $pendingReason = this.getPendingReason();
        result = result * 59 + ($pendingReason == null ? 43 : $pendingReason.hashCode());
        String $protectionEligibility = this.getProtectionEligibility();
        result = result * 59 + ($protectionEligibility == null ? 43 : $protectionEligibility.hashCode());
        String $protectionEligibilityType = this.getProtectionEligibilityType();
        result = result * 59 + ($protectionEligibilityType == null ? 43 : $protectionEligibilityType.hashCode());
        FmfDetails $fmfDetails = this.getFmfDetails();
        result = result * 59 + ($fmfDetails == null ? 43 : ((Object)$fmfDetails).hashCode());
        String $parentPayment = this.getParentPayment();
        result = result * 59 + ($parentPayment == null ? 43 : $parentPayment.hashCode());
        String $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : $validUntil.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        List<Links> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Authorization(id=" + this.getId() + ", amount=" + this.getAmount() + ", paymentMode=" + this.getPaymentMode() + ", state=" + this.getState() + ", reasonCode=" + this.getReasonCode() + ", pendingReason=" + this.getPendingReason() + ", protectionEligibility=" + this.getProtectionEligibility() + ", protectionEligibilityType=" + this.getProtectionEligibilityType() + ", fmfDetails=" + this.getFmfDetails() + ", parentPayment=" + this.getParentPayment() + ", validUntil=" + this.getValidUntil() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", links=" + this.getLinks() + ")";
    }
}

