/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.openidconnect.CreateFromAuthorizationCodeParameters;
import com.paypal.api.openidconnect.Tokeninfo;
import com.paypal.api.payments.BillingInfo;
import com.paypal.api.payments.CancelNotification;
import com.paypal.api.payments.Cost;
import com.paypal.api.payments.Currency;
import com.paypal.api.payments.CustomAmount;
import com.paypal.api.payments.InvoiceItem;
import com.paypal.api.payments.Invoices;
import com.paypal.api.payments.MerchantInfo;
import com.paypal.api.payments.Metadata;
import com.paypal.api.payments.Notification;
import com.paypal.api.payments.PaymentDetail;
import com.paypal.api.payments.PaymentTerm;
import com.paypal.api.payments.RefundDetail;
import com.paypal.api.payments.Search;
import com.paypal.api.payments.ShippingCost;
import com.paypal.api.payments.ShippingInfo;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.List;

public class Invoice
extends PayPalResource {
    private String id;
    private String number;
    private String uri;
    private String status;
    private MerchantInfo merchantInfo;
    private List<BillingInfo> billingInfo;
    private ShippingInfo shippingInfo;
    private List<InvoiceItem> items;
    private String invoiceDate;
    private PaymentTerm paymentTerm;
    private Cost discount;
    private ShippingCost shippingCost;
    private CustomAmount custom;
    private Boolean taxCalculatedAfterDiscount;
    private Boolean taxInclusive;
    private String terms;
    private String note;
    private String merchantMemo;
    private String logoUrl;
    private Currency totalAmount;
    private List<PaymentDetail> paymentDetails;
    private List<RefundDetail> refundDetails;
    private Metadata metadata;

    public Invoice() {
    }

    public Invoice(MerchantInfo merchantInfo) {
        this.merchantInfo = merchantInfo;
    }

    public Invoice create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public Invoice create(APIContext apiContext) throws PayPalRESTException {
        String resourcePath = "v1/invoicing/invoices";
        String payLoad = this.toJSON();
        return Invoice.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Invoice.class);
    }

    public Invoices search(String accessToken, Search search) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.search(apiContext, search);
    }

    public Invoices search(APIContext apiContext, Search search) throws PayPalRESTException {
        if (search == null) {
            throw new IllegalArgumentException("search cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/search";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = search.toJSON();
        return Invoice.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Invoices.class);
    }

    public void send(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.send(apiContext);
    }

    public void send(APIContext apiContext) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}/send";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        Invoice.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void remind(String accessToken, Notification notification) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.remind(apiContext, notification);
    }

    public void remind(APIContext apiContext, Notification notification) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (notification == null) {
            throw new IllegalArgumentException("notification cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}/remind";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = notification.toJSON();
        Invoice.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void cancel(String accessToken, CancelNotification cancelNotification) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.cancel(apiContext, cancelNotification);
    }

    public void cancel(APIContext apiContext, CancelNotification cancelNotification) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (cancelNotification == null) {
            throw new IllegalArgumentException("cancelNotification cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}/cancel";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = cancelNotification.toJSON();
        Invoice.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void recordPayment(String accessToken, PaymentDetail paymentDetail) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.recordPayment(apiContext, paymentDetail);
    }

    public void recordPayment(APIContext apiContext, PaymentDetail paymentDetail) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (paymentDetail == null) {
            throw new IllegalArgumentException("paymentDetail cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}/record-payment";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = paymentDetail.toJSON();
        Invoice.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void recordRefund(String accessToken, RefundDetail refundDetail) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.recordRefund(apiContext, refundDetail);
    }

    public void recordRefund(APIContext apiContext, RefundDetail refundDetail) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (refundDetail == null) {
            throw new IllegalArgumentException("refundDetail cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}/record-refund";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = refundDetail.toJSON();
        Invoice.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public static Invoice get(String accessToken, String invoiceId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Invoice.get(apiContext, invoiceId);
    }

    public static Invoice get(APIContext apiContext, String invoiceId) throws PayPalRESTException {
        if (invoiceId == null) {
            throw new IllegalArgumentException("invoiceId cannot be null");
        }
        Object[] parameters = new Object[]{invoiceId};
        String pattern = "v1/invoicing/invoices/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Invoice.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Invoice.class);
    }

    public static Invoices getAll(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Invoice.getAll(apiContext);
    }

    public static Invoices getAll(APIContext apiContext) throws PayPalRESTException {
        String resourcePath = "v1/invoicing/invoices";
        String payLoad = "";
        Invoices invoices = Invoice.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Invoices.class);
        return invoices;
    }

    public Invoice update(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.update(apiContext);
    }

    public Invoice update(APIContext apiContext) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = this.toJSON();
        return Invoice.configureAndExecute(apiContext, HttpMethod.PUT, resourcePath, payLoad, Invoice.class);
    }

    public void delete(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.delete(apiContext);
    }

    public void delete(APIContext apiContext) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        apiContext.setMaskRequestId(true);
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        Invoice.configureAndExecute(apiContext, HttpMethod.DELETE, resourcePath, payLoad, null);
    }

    public static String fetchRefreshToken(APIContext context, String authorizationCode) throws PayPalRESTException {
        CreateFromAuthorizationCodeParameters params = new CreateFromAuthorizationCodeParameters();
        params.setClientID(context.getClientID());
        params.setClientSecret(context.getClientSecret());
        params.setCode(authorizationCode);
        params.setGrantType("authorization_code");
        Tokeninfo info = Tokeninfo.createFromAuthorizationCode(context, params);
        return info.getRefreshToken();
    }

    public String getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getUri() {
        return this.uri;
    }

    public String getStatus() {
        return this.status;
    }

    public MerchantInfo getMerchantInfo() {
        return this.merchantInfo;
    }

    public List<BillingInfo> getBillingInfo() {
        return this.billingInfo;
    }

    public ShippingInfo getShippingInfo() {
        return this.shippingInfo;
    }

    public List<InvoiceItem> getItems() {
        return this.items;
    }

    public String getInvoiceDate() {
        return this.invoiceDate;
    }

    public PaymentTerm getPaymentTerm() {
        return this.paymentTerm;
    }

    public Cost getDiscount() {
        return this.discount;
    }

    public ShippingCost getShippingCost() {
        return this.shippingCost;
    }

    public CustomAmount getCustom() {
        return this.custom;
    }

    public Boolean getTaxCalculatedAfterDiscount() {
        return this.taxCalculatedAfterDiscount;
    }

    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public String getTerms() {
        return this.terms;
    }

    public String getNote() {
        return this.note;
    }

    public String getMerchantMemo() {
        return this.merchantMemo;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public Currency getTotalAmount() {
        return this.totalAmount;
    }

    public List<PaymentDetail> getPaymentDetails() {
        return this.paymentDetails;
    }

    public List<RefundDetail> getRefundDetails() {
        return this.refundDetails;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Invoice setId(String id) {
        this.id = id;
        return this;
    }

    public Invoice setNumber(String number) {
        this.number = number;
        return this;
    }

    public Invoice setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public Invoice setStatus(String status) {
        this.status = status;
        return this;
    }

    public Invoice setMerchantInfo(MerchantInfo merchantInfo) {
        this.merchantInfo = merchantInfo;
        return this;
    }

    public Invoice setBillingInfo(List<BillingInfo> billingInfo) {
        this.billingInfo = billingInfo;
        return this;
    }

    public Invoice setShippingInfo(ShippingInfo shippingInfo) {
        this.shippingInfo = shippingInfo;
        return this;
    }

    public Invoice setItems(List<InvoiceItem> items) {
        this.items = items;
        return this;
    }

    public Invoice setInvoiceDate(String invoiceDate) {
        this.invoiceDate = invoiceDate;
        return this;
    }

    public Invoice setPaymentTerm(PaymentTerm paymentTerm) {
        this.paymentTerm = paymentTerm;
        return this;
    }

    public Invoice setDiscount(Cost discount) {
        this.discount = discount;
        return this;
    }

    public Invoice setShippingCost(ShippingCost shippingCost) {
        this.shippingCost = shippingCost;
        return this;
    }

    public Invoice setCustom(CustomAmount custom) {
        this.custom = custom;
        return this;
    }

    public Invoice setTaxCalculatedAfterDiscount(Boolean taxCalculatedAfterDiscount) {
        this.taxCalculatedAfterDiscount = taxCalculatedAfterDiscount;
        return this;
    }

    public Invoice setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    public Invoice setTerms(String terms) {
        this.terms = terms;
        return this;
    }

    public Invoice setNote(String note) {
        this.note = note;
        return this;
    }

    public Invoice setMerchantMemo(String merchantMemo) {
        this.merchantMemo = merchantMemo;
        return this;
    }

    public Invoice setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    public Invoice setTotalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    public Invoice setPaymentDetails(List<PaymentDetail> paymentDetails) {
        this.paymentDetails = paymentDetails;
        return this;
    }

    public Invoice setRefundDetails(List<RefundDetail> refundDetails) {
        this.refundDetails = refundDetails;
        return this;
    }

    public Invoice setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        MerchantInfo this$merchantInfo = this.getMerchantInfo();
        MerchantInfo other$merchantInfo = other.getMerchantInfo();
        if (this$merchantInfo == null ? other$merchantInfo != null : !((Object)this$merchantInfo).equals(other$merchantInfo)) {
            return false;
        }
        List<BillingInfo> this$billingInfo = this.getBillingInfo();
        List<BillingInfo> other$billingInfo = other.getBillingInfo();
        if (this$billingInfo == null ? other$billingInfo != null : !((Object)this$billingInfo).equals(other$billingInfo)) {
            return false;
        }
        ShippingInfo this$shippingInfo = this.getShippingInfo();
        ShippingInfo other$shippingInfo = other.getShippingInfo();
        if (this$shippingInfo == null ? other$shippingInfo != null : !((Object)this$shippingInfo).equals(other$shippingInfo)) {
            return false;
        }
        List<InvoiceItem> this$items = this.getItems();
        List<InvoiceItem> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        String this$invoiceDate = this.getInvoiceDate();
        String other$invoiceDate = other.getInvoiceDate();
        if (this$invoiceDate == null ? other$invoiceDate != null : !this$invoiceDate.equals(other$invoiceDate)) {
            return false;
        }
        PaymentTerm this$paymentTerm = this.getPaymentTerm();
        PaymentTerm other$paymentTerm = other.getPaymentTerm();
        if (this$paymentTerm == null ? other$paymentTerm != null : !((Object)this$paymentTerm).equals(other$paymentTerm)) {
            return false;
        }
        Cost this$discount = this.getDiscount();
        Cost other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        ShippingCost this$shippingCost = this.getShippingCost();
        ShippingCost other$shippingCost = other.getShippingCost();
        if (this$shippingCost == null ? other$shippingCost != null : !((Object)this$shippingCost).equals(other$shippingCost)) {
            return false;
        }
        CustomAmount this$custom = this.getCustom();
        CustomAmount other$custom = other.getCustom();
        if (this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom)) {
            return false;
        }
        Boolean this$taxCalculatedAfterDiscount = this.getTaxCalculatedAfterDiscount();
        Boolean other$taxCalculatedAfterDiscount = other.getTaxCalculatedAfterDiscount();
        if (this$taxCalculatedAfterDiscount == null ? other$taxCalculatedAfterDiscount != null : !((Object)this$taxCalculatedAfterDiscount).equals(other$taxCalculatedAfterDiscount)) {
            return false;
        }
        Boolean this$taxInclusive = this.getTaxInclusive();
        Boolean other$taxInclusive = other.getTaxInclusive();
        if (this$taxInclusive == null ? other$taxInclusive != null : !((Object)this$taxInclusive).equals(other$taxInclusive)) {
            return false;
        }
        String this$terms = this.getTerms();
        String other$terms = other.getTerms();
        if (this$terms == null ? other$terms != null : !this$terms.equals(other$terms)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        String this$merchantMemo = this.getMerchantMemo();
        String other$merchantMemo = other.getMerchantMemo();
        if (this$merchantMemo == null ? other$merchantMemo != null : !this$merchantMemo.equals(other$merchantMemo)) {
            return false;
        }
        String this$logoUrl = this.getLogoUrl();
        String other$logoUrl = other.getLogoUrl();
        if (this$logoUrl == null ? other$logoUrl != null : !this$logoUrl.equals(other$logoUrl)) {
            return false;
        }
        Currency this$totalAmount = this.getTotalAmount();
        Currency other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        List<PaymentDetail> this$paymentDetails = this.getPaymentDetails();
        List<PaymentDetail> other$paymentDetails = other.getPaymentDetails();
        if (this$paymentDetails == null ? other$paymentDetails != null : !((Object)this$paymentDetails).equals(other$paymentDetails)) {
            return false;
        }
        List<RefundDetail> this$refundDetails = this.getRefundDetails();
        List<RefundDetail> other$refundDetails = other.getRefundDetails();
        if (this$refundDetails == null ? other$refundDetails != null : !((Object)this$refundDetails).equals(other$refundDetails)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Invoice;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        MerchantInfo $merchantInfo = this.getMerchantInfo();
        result = result * 59 + ($merchantInfo == null ? 43 : ((Object)$merchantInfo).hashCode());
        List<BillingInfo> $billingInfo = this.getBillingInfo();
        result = result * 59 + ($billingInfo == null ? 43 : ((Object)$billingInfo).hashCode());
        ShippingInfo $shippingInfo = this.getShippingInfo();
        result = result * 59 + ($shippingInfo == null ? 43 : ((Object)$shippingInfo).hashCode());
        List<InvoiceItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        String $invoiceDate = this.getInvoiceDate();
        result = result * 59 + ($invoiceDate == null ? 43 : $invoiceDate.hashCode());
        PaymentTerm $paymentTerm = this.getPaymentTerm();
        result = result * 59 + ($paymentTerm == null ? 43 : ((Object)$paymentTerm).hashCode());
        Cost $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        ShippingCost $shippingCost = this.getShippingCost();
        result = result * 59 + ($shippingCost == null ? 43 : ((Object)$shippingCost).hashCode());
        CustomAmount $custom = this.getCustom();
        result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
        Boolean $taxCalculatedAfterDiscount = this.getTaxCalculatedAfterDiscount();
        result = result * 59 + ($taxCalculatedAfterDiscount == null ? 43 : ((Object)$taxCalculatedAfterDiscount).hashCode());
        Boolean $taxInclusive = this.getTaxInclusive();
        result = result * 59 + ($taxInclusive == null ? 43 : ((Object)$taxInclusive).hashCode());
        String $terms = this.getTerms();
        result = result * 59 + ($terms == null ? 43 : $terms.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        String $merchantMemo = this.getMerchantMemo();
        result = result * 59 + ($merchantMemo == null ? 43 : $merchantMemo.hashCode());
        String $logoUrl = this.getLogoUrl();
        result = result * 59 + ($logoUrl == null ? 43 : $logoUrl.hashCode());
        Currency $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        List<PaymentDetail> $paymentDetails = this.getPaymentDetails();
        result = result * 59 + ($paymentDetails == null ? 43 : ((Object)$paymentDetails).hashCode());
        List<RefundDetail> $refundDetails = this.getRefundDetails();
        result = result * 59 + ($refundDetails == null ? 43 : ((Object)$refundDetails).hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Invoice(id=" + this.getId() + ", number=" + this.getNumber() + ", uri=" + this.getUri() + ", status=" + this.getStatus() + ", merchantInfo=" + this.getMerchantInfo() + ", billingInfo=" + this.getBillingInfo() + ", shippingInfo=" + this.getShippingInfo() + ", items=" + this.getItems() + ", invoiceDate=" + this.getInvoiceDate() + ", paymentTerm=" + this.getPaymentTerm() + ", discount=" + this.getDiscount() + ", shippingCost=" + this.getShippingCost() + ", custom=" + this.getCustom() + ", taxCalculatedAfterDiscount=" + this.getTaxCalculatedAfterDiscount() + ", taxInclusive=" + this.getTaxInclusive() + ", terms=" + this.getTerms() + ", note=" + this.getNote() + ", merchantMemo=" + this.getMerchantMemo() + ", logoUrl=" + this.getLogoUrl() + ", totalAmount=" + this.getTotalAmount() + ", paymentDetails=" + this.getPaymentDetails() + ", refundDetails=" + this.getRefundDetails() + ", metadata=" + this.getMetadata() + ")";
    }
}

