/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Links;
import com.paypal.api.payments.MerchantPreferences;
import com.paypal.api.payments.Patch;
import com.paypal.api.payments.PaymentDefinition;
import com.paypal.api.payments.PlanList;
import com.paypal.api.payments.Terms;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.JSONFormatter;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.List;
import java.util.Map;

public class Plan
extends PayPalResource {
    private String id;
    private String name;
    private String description;
    private String type;
    private String state;
    private String createTime;
    private String updateTime;
    private List<PaymentDefinition> paymentDefinitions;
    private List<Terms> terms;
    private MerchantPreferences merchantPreferences;
    private List<Links> links;

    public Plan() {
    }

    public Plan(String name, String description, String type) {
        this.name = name;
        this.description = description;
        this.type = type;
    }

    public static Plan get(String accessToken, String planId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Plan.get(apiContext, planId);
    }

    public static Plan get(APIContext apiContext, String planId) throws PayPalRESTException {
        if (planId == null) {
            throw new IllegalArgumentException("planId cannot be null");
        }
        Object[] parameters = new Object[]{planId};
        String pattern = "v1/payments/billing-plans/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Plan.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Plan.class);
    }

    public Plan create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public Plan create(APIContext apiContext) throws PayPalRESTException {
        String resourcePath = "v1/payments/billing-plans";
        String payLoad = this.toJSON();
        return Plan.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Plan.class);
    }

    public void update(String accessToken, List<Patch> patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.update(apiContext, patchRequest);
    }

    public void update(APIContext apiContext, List<Patch> patchRequest) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-plans/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = JSONFormatter.toJSON(patchRequest);
        Plan.configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, null);
    }

    public static PlanList list(String accessToken, Map<String, String> containerMap) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Plan.list(apiContext, containerMap);
    }

    public static PlanList list(APIContext apiContext, Map<String, String> containerMap) throws PayPalRESTException {
        if (containerMap == null) {
            throw new IllegalArgumentException("containerMap cannot be null");
        }
        Object[] parameters = new Object[]{containerMap};
        String pattern = "v1/payments/billing-plans?page_size={0}&status={1}&page={2}&total_required={3}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        PlanList plans = Plan.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, PlanList.class);
        return plans;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getState() {
        return this.state;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public List<PaymentDefinition> getPaymentDefinitions() {
        return this.paymentDefinitions;
    }

    public List<Terms> getTerms() {
        return this.terms;
    }

    public MerchantPreferences getMerchantPreferences() {
        return this.merchantPreferences;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Plan setId(String id) {
        this.id = id;
        return this;
    }

    public Plan setName(String name) {
        this.name = name;
        return this;
    }

    public Plan setDescription(String description) {
        this.description = description;
        return this;
    }

    public Plan setType(String type) {
        this.type = type;
        return this;
    }

    public Plan setState(String state) {
        this.state = state;
        return this;
    }

    public Plan setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public Plan setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public Plan setPaymentDefinitions(List<PaymentDefinition> paymentDefinitions) {
        this.paymentDefinitions = paymentDefinitions;
        return this;
    }

    public Plan setTerms(List<Terms> terms) {
        this.terms = terms;
        return this;
    }

    public Plan setMerchantPreferences(MerchantPreferences merchantPreferences) {
        this.merchantPreferences = merchantPreferences;
        return this;
    }

    public Plan setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plan)) {
            return false;
        }
        Plan other = (Plan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        List<PaymentDefinition> this$paymentDefinitions = this.getPaymentDefinitions();
        List<PaymentDefinition> other$paymentDefinitions = other.getPaymentDefinitions();
        if (this$paymentDefinitions == null ? other$paymentDefinitions != null : !((Object)this$paymentDefinitions).equals(other$paymentDefinitions)) {
            return false;
        }
        List<Terms> this$terms = this.getTerms();
        List<Terms> other$terms = other.getTerms();
        if (this$terms == null ? other$terms != null : !((Object)this$terms).equals(other$terms)) {
            return false;
        }
        MerchantPreferences this$merchantPreferences = this.getMerchantPreferences();
        MerchantPreferences other$merchantPreferences = other.getMerchantPreferences();
        if (this$merchantPreferences == null ? other$merchantPreferences != null : !((Object)this$merchantPreferences).equals(other$merchantPreferences)) {
            return false;
        }
        List<Links> this$links = this.getLinks();
        List<Links> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Plan;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        List<PaymentDefinition> $paymentDefinitions = this.getPaymentDefinitions();
        result = result * 59 + ($paymentDefinitions == null ? 43 : ((Object)$paymentDefinitions).hashCode());
        List<Terms> $terms = this.getTerms();
        result = result * 59 + ($terms == null ? 43 : ((Object)$terms).hashCode());
        MerchantPreferences $merchantPreferences = this.getMerchantPreferences();
        result = result * 59 + ($merchantPreferences == null ? 43 : ((Object)$merchantPreferences).hashCode());
        List<Links> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Plan(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", state=" + this.getState() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", paymentDefinitions=" + this.getPaymentDefinitions() + ", terms=" + this.getTerms() + ", merchantPreferences=" + this.getMerchantPreferences() + ", links=" + this.getLinks() + ")";
    }
}

