/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.EventType;
import com.paypal.api.payments.Links;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.List;

public class Webhook
extends PayPalResource {
    private String id;
    private String url;
    private List<EventType> eventTypes;
    private List<Links> links;

    public Webhook() {
    }

    public Webhook(String url, List<EventType> eventTypes) {
        this.url = url;
        this.eventTypes = eventTypes;
    }

    public Webhook create(String accessToken, Webhook webhook) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext, webhook);
    }

    public Webhook create(APIContext apiContext, Webhook webhook) throws PayPalRESTException {
        if (webhook == null) {
            throw new IllegalArgumentException("webhook cannot be null");
        }
        Object[] parameters = new Object[]{};
        String pattern = "v1/notifications/webhooks";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = webhook.toJSON();
        return Webhook.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Webhook.class);
    }

    public Webhook get(String accessToken, String webhookId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.get(apiContext, webhookId);
    }

    public Webhook get(APIContext apiContext, String webhookId) throws PayPalRESTException {
        if (webhookId == null) {
            throw new IllegalArgumentException("webhookId cannot be null");
        }
        Object[] parameters = new Object[]{webhookId};
        String pattern = "v1/notifications/webhooks/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Webhook.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Webhook.class);
    }

    public Webhook update(String accessToken, String webhookId, String patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.update(apiContext, webhookId, patchRequest);
    }

    public Webhook update(APIContext apiContext, String webhookId, String patchRequest) throws PayPalRESTException {
        if (webhookId == null) {
            throw new IllegalArgumentException("webhookId cannot be null");
        }
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        Object[] parameters = new Object[]{webhookId};
        String pattern = "v1/notifications/webhooks/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = patchRequest;
        return Webhook.configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, Webhook.class);
    }

    public void delete(String accessToken, String webhookId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.delete(apiContext, webhookId);
    }

    public void delete(APIContext apiContext, String webhookId) throws PayPalRESTException {
        if (webhookId == null) {
            throw new IllegalArgumentException("webhookId cannot be null");
        }
        Object[] parameters = new Object[]{webhookId};
        String pattern = "v1/notifications/webhooks/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        Webhook.configureAndExecute(apiContext, HttpMethod.DELETE, resourcePath, payLoad, null);
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public List<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Webhook setId(String id) {
        this.id = id;
        return this;
    }

    public Webhook setUrl(String url) {
        this.url = url;
        return this;
    }

    public Webhook setEventTypes(List<EventType> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    public Webhook setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Webhook)) {
            return false;
        }
        Webhook other = (Webhook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<EventType> this$eventTypes = this.getEventTypes();
        List<EventType> other$eventTypes = other.getEventTypes();
        if (this$eventTypes == null ? other$eventTypes != null : !((Object)this$eventTypes).equals(other$eventTypes)) {
            return false;
        }
        List<Links> this$links = this.getLinks();
        List<Links> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Webhook;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<EventType> $eventTypes = this.getEventTypes();
        result = result * 59 + ($eventTypes == null ? 43 : ((Object)$eventTypes).hashCode());
        List<Links> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Webhook(id=" + this.getId() + ", url=" + this.getUrl() + ", eventTypes=" + this.getEventTypes() + ", links=" + this.getLinks() + ")";
    }
}

