// Generated by delombok at Thu Jul 07 14:04:29 CDT 2016
package com.paypal.api.payments;

import com.paypal.base.rest.PayPalModel;
import java.util.List;

public class Item extends PayPalModel {
	/**
	 * Stock keeping unit corresponding (SKU) to item.
	 */
	private String sku;
	/**
	 * Item name. 127 characters max.
	 */
	private String name;
	/**
	 * Description of the item. Only supported when the `payment_method` is set to `paypal`.
	 */
	private String description;
	/**
	 * Number of a particular item. 10 characters max.
	 */
	private String quantity;
	/**
	 * Item cost. 10 characters max.
	 */
	private String price;
	/**
	 * 3-letter [currency code](https://developer.paypal.com/docs/integration/direct/rest_api_payment_country_currency_support/).
	 */
	private String currency;
	/**
	 * Tax of the item. Only supported when the `payment_method` is set to `paypal`.
	 */
	private String tax;
	/**
	 * URL linking to item information. Available to payer in transaction history.
	 */
	private String url;
	/**
	 * Category type of the item.
	 */
	private String category;
	/**
	 * Weight of the item.
	 */
	private Measurement weight;
	/**
	 * Length of the item.
	 */
	private Measurement length;
	/**
	 * Height of the item.
	 */
	private Measurement height;
	/**
	 * Width of the item.
	 */
	private Measurement width;
	/**
	 * Set of optional data used for PayPal risk determination.
	 */
	private List<NameValuePair> supplementaryData;
	/**
	 * Set of optional data used for PayPal post-transaction notifications.
	 */
	private List<NameValuePair> postbackData;

	/**
	 * Default Constructor
	 */
	public Item() {
	}

	/**
	 * Parameterized Constructor
	 */
	public Item(String name, String quantity, String price, String currency) {
		this.name = name;
		this.quantity = quantity;
		this.price = price;
		this.currency = currency;
	}

	/**
	 * Stock keeping unit corresponding (SKU) to item.
	 */
	@java.lang.SuppressWarnings("all")
	public String getSku() {
		return this.sku;
	}

	/**
	 * Item name. 127 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getName() {
		return this.name;
	}

	/**
	 * Description of the item. Only supported when the `payment_method` is set to `paypal`.
	 */
	@java.lang.SuppressWarnings("all")
	public String getDescription() {
		return this.description;
	}

	/**
	 * Number of a particular item. 10 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getQuantity() {
		return this.quantity;
	}

	/**
	 * Item cost. 10 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getPrice() {
		return this.price;
	}

	/**
	 * 3-letter [currency code](https://developer.paypal.com/docs/integration/direct/rest_api_payment_country_currency_support/).
	 */
	@java.lang.SuppressWarnings("all")
	public String getCurrency() {
		return this.currency;
	}

	/**
	 * Tax of the item. Only supported when the `payment_method` is set to `paypal`.
	 */
	@java.lang.SuppressWarnings("all")
	public String getTax() {
		return this.tax;
	}

	/**
	 * URL linking to item information. Available to payer in transaction history.
	 */
	@java.lang.SuppressWarnings("all")
	public String getUrl() {
		return this.url;
	}

	/**
	 * Category type of the item.
	 */
	@java.lang.SuppressWarnings("all")
	public String getCategory() {
		return this.category;
	}

	/**
	 * Weight of the item.
	 */
	@java.lang.SuppressWarnings("all")
	public Measurement getWeight() {
		return this.weight;
	}

	/**
	 * Length of the item.
	 */
	@java.lang.SuppressWarnings("all")
	public Measurement getLength() {
		return this.length;
	}

	/**
	 * Height of the item.
	 */
	@java.lang.SuppressWarnings("all")
	public Measurement getHeight() {
		return this.height;
	}

	/**
	 * Width of the item.
	 */
	@java.lang.SuppressWarnings("all")
	public Measurement getWidth() {
		return this.width;
	}

	/**
	 * Set of optional data used for PayPal risk determination.
	 */
	@java.lang.SuppressWarnings("all")
	public List<NameValuePair> getSupplementaryData() {
		return this.supplementaryData;
	}

	/**
	 * Set of optional data used for PayPal post-transaction notifications.
	 */
	@java.lang.SuppressWarnings("all")
	public List<NameValuePair> getPostbackData() {
		return this.postbackData;
	}

	/**
	 * Stock keeping unit corresponding (SKU) to item.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setSku(final String sku) {
		this.sku = sku;
		return this;
	}

	/**
	 * Item name. 127 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setName(final String name) {
		this.name = name;
		return this;
	}

	/**
	 * Description of the item. Only supported when the `payment_method` is set to `paypal`.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setDescription(final String description) {
		this.description = description;
		return this;
	}

	/**
	 * Number of a particular item. 10 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setQuantity(final String quantity) {
		this.quantity = quantity;
		return this;
	}

	/**
	 * Item cost. 10 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setPrice(final String price) {
		this.price = price;
		return this;
	}

	/**
	 * 3-letter [currency code](https://developer.paypal.com/docs/integration/direct/rest_api_payment_country_currency_support/).
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setCurrency(final String currency) {
		this.currency = currency;
		return this;
	}

	/**
	 * Tax of the item. Only supported when the `payment_method` is set to `paypal`.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setTax(final String tax) {
		this.tax = tax;
		return this;
	}

	/**
	 * URL linking to item information. Available to payer in transaction history.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setUrl(final String url) {
		this.url = url;
		return this;
	}

	/**
	 * Category type of the item.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setCategory(final String category) {
		this.category = category;
		return this;
	}

	/**
	 * Weight of the item.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setWeight(final Measurement weight) {
		this.weight = weight;
		return this;
	}

	/**
	 * Length of the item.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setLength(final Measurement length) {
		this.length = length;
		return this;
	}

	/**
	 * Height of the item.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setHeight(final Measurement height) {
		this.height = height;
		return this;
	}

	/**
	 * Width of the item.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setWidth(final Measurement width) {
		this.width = width;
		return this;
	}

	/**
	 * Set of optional data used for PayPal risk determination.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setSupplementaryData(final List<NameValuePair> supplementaryData) {
		this.supplementaryData = supplementaryData;
		return this;
	}

	/**
	 * Set of optional data used for PayPal post-transaction notifications.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Item setPostbackData(final List<NameValuePair> postbackData) {
		this.postbackData = postbackData;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public java.lang.String toString() {
		return "Item(sku=" + this.getSku() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", quantity=" + this.getQuantity() + ", price=" + this.getPrice() + ", currency=" + this.getCurrency() + ", tax=" + this.getTax() + ", url=" + this.getUrl() + ", category=" + this.getCategory() + ", weight=" + this.getWeight() + ", length=" + this.getLength() + ", height=" + this.getHeight() + ", width=" + this.getWidth() + ", supplementaryData=" + this.getSupplementaryData() + ", postbackData=" + this.getPostbackData() + ")";
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof Item)) return false;
		final Item other = (Item) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		if (!super.equals(o)) return false;
		final java.lang.Object this$sku = this.getSku();
		final java.lang.Object other$sku = other.getSku();
		if (this$sku == null ? other$sku != null : !this$sku.equals(other$sku)) return false;
		final java.lang.Object this$name = this.getName();
		final java.lang.Object other$name = other.getName();
		if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
		final java.lang.Object this$description = this.getDescription();
		final java.lang.Object other$description = other.getDescription();
		if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
		final java.lang.Object this$quantity = this.getQuantity();
		final java.lang.Object other$quantity = other.getQuantity();
		if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
		final java.lang.Object this$price = this.getPrice();
		final java.lang.Object other$price = other.getPrice();
		if (this$price == null ? other$price != null : !this$price.equals(other$price)) return false;
		final java.lang.Object this$currency = this.getCurrency();
		final java.lang.Object other$currency = other.getCurrency();
		if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) return false;
		final java.lang.Object this$tax = this.getTax();
		final java.lang.Object other$tax = other.getTax();
		if (this$tax == null ? other$tax != null : !this$tax.equals(other$tax)) return false;
		final java.lang.Object this$url = this.getUrl();
		final java.lang.Object other$url = other.getUrl();
		if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
		final java.lang.Object this$category = this.getCategory();
		final java.lang.Object other$category = other.getCategory();
		if (this$category == null ? other$category != null : !this$category.equals(other$category)) return false;
		final java.lang.Object this$weight = this.getWeight();
		final java.lang.Object other$weight = other.getWeight();
		if (this$weight == null ? other$weight != null : !this$weight.equals(other$weight)) return false;
		final java.lang.Object this$length = this.getLength();
		final java.lang.Object other$length = other.getLength();
		if (this$length == null ? other$length != null : !this$length.equals(other$length)) return false;
		final java.lang.Object this$height = this.getHeight();
		final java.lang.Object other$height = other.getHeight();
		if (this$height == null ? other$height != null : !this$height.equals(other$height)) return false;
		final java.lang.Object this$width = this.getWidth();
		final java.lang.Object other$width = other.getWidth();
		if (this$width == null ? other$width != null : !this$width.equals(other$width)) return false;
		final java.lang.Object this$supplementaryData = this.getSupplementaryData();
		final java.lang.Object other$supplementaryData = other.getSupplementaryData();
		if (this$supplementaryData == null ? other$supplementaryData != null : !this$supplementaryData.equals(other$supplementaryData)) return false;
		final java.lang.Object this$postbackData = this.getPostbackData();
		final java.lang.Object other$postbackData = other.getPostbackData();
		if (this$postbackData == null ? other$postbackData != null : !this$postbackData.equals(other$postbackData)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof Item;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + super.hashCode();
		final java.lang.Object $sku = this.getSku();
		result = result * PRIME + ($sku == null ? 43 : $sku.hashCode());
		final java.lang.Object $name = this.getName();
		result = result * PRIME + ($name == null ? 43 : $name.hashCode());
		final java.lang.Object $description = this.getDescription();
		result = result * PRIME + ($description == null ? 43 : $description.hashCode());
		final java.lang.Object $quantity = this.getQuantity();
		result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
		final java.lang.Object $price = this.getPrice();
		result = result * PRIME + ($price == null ? 43 : $price.hashCode());
		final java.lang.Object $currency = this.getCurrency();
		result = result * PRIME + ($currency == null ? 43 : $currency.hashCode());
		final java.lang.Object $tax = this.getTax();
		result = result * PRIME + ($tax == null ? 43 : $tax.hashCode());
		final java.lang.Object $url = this.getUrl();
		result = result * PRIME + ($url == null ? 43 : $url.hashCode());
		final java.lang.Object $category = this.getCategory();
		result = result * PRIME + ($category == null ? 43 : $category.hashCode());
		final java.lang.Object $weight = this.getWeight();
		result = result * PRIME + ($weight == null ? 43 : $weight.hashCode());
		final java.lang.Object $length = this.getLength();
		result = result * PRIME + ($length == null ? 43 : $length.hashCode());
		final java.lang.Object $height = this.getHeight();
		result = result * PRIME + ($height == null ? 43 : $height.hashCode());
		final java.lang.Object $width = this.getWidth();
		result = result * PRIME + ($width == null ? 43 : $width.hashCode());
		final java.lang.Object $supplementaryData = this.getSupplementaryData();
		result = result * PRIME + ($supplementaryData == null ? 43 : $supplementaryData.hashCode());
		final java.lang.Object $postbackData = this.getPostbackData();
		result = result * PRIME + ($postbackData == null ? 43 : $postbackData.hashCode());
		return result;
	}
}
