/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.EventList;
import com.paypal.api.payments.Links;
import com.paypal.base.SDKUtil;
import com.paypal.base.SSLUtil;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Event
extends PayPalResource {
    private static final Logger log = LoggerFactory.getLogger(Event.class);
    private String id;
    private String createTime;
    private String resourceType;
    private String eventType;
    private String summary;
    private Object resource;
    private List<Links> links;

    public static Event get(String accessToken, String eventId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Event.get(apiContext, eventId);
    }

    public static Event get(APIContext apiContext, String eventId) throws PayPalRESTException {
        if (eventId == null) {
            throw new IllegalArgumentException("eventId cannot be null");
        }
        Object[] parameters = new Object[]{eventId};
        String pattern = "v1/notifications/webhooks-events/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Event.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Event.class);
    }

    public Event resend(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.resend(apiContext);
    }

    public Event resend(APIContext apiContext) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/notifications/webhooks-events/{0}/resend";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Event.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Event.class);
    }

    public static EventList list(String accessToken, String queryParams) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Event.list(apiContext, queryParams);
    }

    public static EventList list(APIContext apiContext, String queryParams) throws PayPalRESTException {
        String resourcePath = "v1/notifications/webhooks-events" + queryParams;
        String payLoad = "";
        return Event.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, EventList.class);
    }

    public static boolean validateReceivedEvent(APIContext apiContext, Map<String, String> headers, String requestBody) throws PayPalRESTException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        if (headers == null) {
            throw new PayPalRESTException("Headers cannot be null");
        }
        HashMap<String, String> cmap = new HashMap();
        Boolean isChainValid = false;
        Boolean isDataValid = false;
        cmap = Event.getConfigurations(apiContext);
        String clientCertificateLocation = SDKUtil.validateAndGet(headers, "Paypal-Cert-Url");
        String trustCertificateLocation = SDKUtil.validateAndGet(cmap, "webhook.trustCert");
        Collection<X509Certificate> clientCerts = SSLUtil.getCertificateFromStream(SSLUtil.downloadCertificateFromPath(clientCertificateLocation));
        Collection<X509Certificate> trustCerts = SSLUtil.getCertificateFromStream(Event.class.getClassLoader().getResourceAsStream(trustCertificateLocation));
        isChainValid = SSLUtil.validateCertificateChain(clientCerts, trustCerts, SDKUtil.validateAndGet(cmap, "webhook.authType"));
        log.debug("Is Chain Valid: " + isChainValid);
        if (isChainValid.booleanValue()) {
            String webhookId = SDKUtil.validateAndGet(cmap, "webhook.id");
            String actualSignatureEncoded = SDKUtil.validateAndGet(headers, "Paypal-Transmission-Sig");
            String authAlgo = SDKUtil.validateAndGet(headers, "Paypal-Auth-Algo");
            String transmissionId = SDKUtil.validateAndGet(headers, "Paypal-Transmission-Id");
            String transmissionTime = SDKUtil.validateAndGet(headers, "Paypal-Transmission-Time");
            String expectedSignature = String.format("%s|%s|%s|%s", transmissionId, transmissionTime, webhookId, SSLUtil.crc32(requestBody));
            isDataValid = SSLUtil.validateData(clientCerts, authAlgo, actualSignatureEncoded, expectedSignature, requestBody, webhookId);
            log.debug("Is Data Valid: " + isDataValid);
            return isDataValid;
        }
        return false;
    }

    private static Map<String, String> getConfigurations(APIContext apiContext) {
        Map<Object, Object> cmap = new HashMap();
        if (apiContext != null) {
            if (apiContext.getConfigurationMap() == null) {
                apiContext.setConfigurationMap(new HashMap<String, String>());
            }
            cmap = SDKUtil.combineDefaultMap(apiContext.getConfigurationMap());
            cmap = SDKUtil.combineMap(cmap, PayPalResource.getConfigurations());
        } else {
            cmap = SDKUtil.combineDefaultMap(PayPalResource.getConfigurations());
        }
        return cmap;
    }

    public String getId() {
        return this.id;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getSummary() {
        return this.summary;
    }

    public Object getResource() {
        return this.resource;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Event setId(String id) {
        this.id = id;
        return this;
    }

    public Event setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public Event setResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public Event setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public Event setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public Event setResource(Object resource) {
        this.resource = resource;
        return this;
    }

    public Event setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    @Override
    public String toString() {
        return "Event(id=" + this.getId() + ", createTime=" + this.getCreateTime() + ", resourceType=" + this.getResourceType() + ", eventType=" + this.getEventType() + ", summary=" + this.getSummary() + ", resource=" + this.getResource() + ", links=" + this.getLinks() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        Object this$resource = this.getResource();
        Object other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        List<Links> this$links = this.getLinks();
        List<Links> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        Object $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        List<Links> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }
}

