/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Currency;
import com.paypal.api.payments.PayoutItemDetails;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;

public class PayoutItem
extends PayPalResource {
    private String recipientType;
    private Currency amount;
    private String note;
    private String receiver;
    private String senderItemId;

    public PayoutItem() {
    }

    public PayoutItem(Currency amount, String receiver) {
        this.amount = amount;
        this.receiver = receiver;
    }

    public static PayoutItemDetails get(String accessToken, String payoutItemId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return PayoutItem.get(apiContext, payoutItemId);
    }

    public static PayoutItemDetails get(APIContext apiContext, String payoutItemId) throws PayPalRESTException {
        if (payoutItemId == null) {
            throw new IllegalArgumentException("payoutItemId cannot be null");
        }
        Object[] parameters = new Object[]{payoutItemId};
        String pattern = "v1/payments/payouts-item/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayoutItem.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, PayoutItemDetails.class);
    }

    public static PayoutItemDetails cancel(String accessToken, String payoutItemId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return PayoutItem.cancel(apiContext, payoutItemId);
    }

    public static PayoutItemDetails cancel(APIContext apiContext, String payoutItemId) throws PayPalRESTException {
        if (payoutItemId == null) {
            throw new IllegalArgumentException("payoutItemId cannot be null");
        }
        Object[] parameters = new Object[]{payoutItemId};
        String pattern = "v1/payments/payouts-item/{0}/cancel";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayoutItem.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, PayoutItemDetails.class);
    }

    public String getRecipientType() {
        return this.recipientType;
    }

    public Currency getAmount() {
        return this.amount;
    }

    public String getNote() {
        return this.note;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public String getSenderItemId() {
        return this.senderItemId;
    }

    public PayoutItem setRecipientType(String recipientType) {
        this.recipientType = recipientType;
        return this;
    }

    public PayoutItem setAmount(Currency amount) {
        this.amount = amount;
        return this;
    }

    public PayoutItem setNote(String note) {
        this.note = note;
        return this;
    }

    public PayoutItem setReceiver(String receiver) {
        this.receiver = receiver;
        return this;
    }

    public PayoutItem setSenderItemId(String senderItemId) {
        this.senderItemId = senderItemId;
        return this;
    }

    @Override
    public String toString() {
        return "PayoutItem(recipientType=" + this.getRecipientType() + ", amount=" + this.getAmount() + ", note=" + this.getNote() + ", receiver=" + this.getReceiver() + ", senderItemId=" + this.getSenderItemId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayoutItem)) {
            return false;
        }
        PayoutItem other = (PayoutItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$recipientType = this.getRecipientType();
        String other$recipientType = other.getRecipientType();
        if (this$recipientType == null ? other$recipientType != null : !this$recipientType.equals(other$recipientType)) {
            return false;
        }
        Currency this$amount = this.getAmount();
        Currency other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        String this$receiver = this.getReceiver();
        String other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        String this$senderItemId = this.getSenderItemId();
        String other$senderItemId = other.getSenderItemId();
        return !(this$senderItemId == null ? other$senderItemId != null : !this$senderItemId.equals(other$senderItemId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PayoutItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $recipientType = this.getRecipientType();
        result = result * 59 + ($recipientType == null ? 43 : $recipientType.hashCode());
        Currency $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        String $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        String $senderItemId = this.getSenderItemId();
        result = result * 59 + ($senderItemId == null ? 43 : $senderItemId.hashCode());
        return result;
    }
}

