// Generated by delombok at Wed Jul 13 11:59:20 CDT 2016
package com.paypal.api.payments;

import com.google.gson.GsonBuilder;
import com.paypal.base.rest.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreditCard extends PayPalResource {
	/**
	 * ID of the credit card being saved for later use.
	 */
	private String id;
	/**
	 * Card number.
	 */
	private String number;
	/**
	 * Type of the Card (eg. Visa, Mastercard, etc.).
	 */
	private String type;
	/**
	 * 2 digit card expiry month.
	 */
	private int expireMonth;
	/**
	 * 4 digit card expiry year
	 */
	private int expireYear;
	/**
	 * Card validation code. Only supported when making a Payment but not when saving a credit card for future use.
	 */
	private Integer cvv2;
	/**
	 * Card holder's first name.
	 */
	private String firstName;
	/**
	 * Card holder's last name.
	 */
	private String lastName;
	/**
	 * Billing Address associated with this card.
	 */
	private Address billingAddress;
	/**
	 * A unique identifier of the customer to whom this bank account belongs to. Generated and provided by the facilitator. This is required when creating or using a stored funding instrument in vault.
	 */
	private String externalCustomerId;
	/**
	 * State of the funding instrument.
	 */
	private String state;
	/**
	 * Date/Time until this resource can be used to fund a payment.
	 */
	private String validUntil;
	/**
	 */
	private List<Links> links;
	/**
	 * Payer ID
	 */
	private String payerId;

	/**
	 * Default Constructor
	 */
	public CreditCard() {
	}

	/**
	 * Getter for cvv2
	 * Returns -1 if <code>cvv2</code> is null.
	 * Not autogenerating using lombok as it includes logic to return -1 on null.
	 */
	public int getCvv2() {
		if (this.cvv2 == null) {
			return -1;
		} else {
			return this.cvv2;
		}
	}

	/**
	 * Parameterized Constructor
	 */
	public CreditCard(String number, String type, int expireMonth, int expireYear) {
		this.number = number;
		this.type = type;
		this.expireMonth = expireMonth;
		this.expireYear = expireYear;
	}

	/**
	 * Creates a new Credit Card Resource (aka Tokenize).
	 * @deprecated Please use {@link #create(APIContext)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @return CreditCard
	 * @throws PayPalRESTException
	 */
	public CreditCard create(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return create(apiContext);
	}

	/**
	 * Creates a new Credit Card Resource (aka Tokenize).
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @return CreditCard
	 * @throws PayPalRESTException
	 */
	public CreditCard create(APIContext apiContext) throws PayPalRESTException {
		String resourcePath = "v1/vault/credit-cards";
		String payLoad = this.toJSON();
		return configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, CreditCard.class);
	}

	/**
	 * Obtain the Credit Card resource for the given identifier.
	 * @deprecated Please use {@link #get(APIContext, String)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param creditCardId
	 * String
	 * @return CreditCard
	 * @throws PayPalRESTException
	 */
	public static CreditCard get(String accessToken, String creditCardId) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return get(apiContext, creditCardId);
	}

	/**
	 * Obtain the Credit Card resource for the given identifier.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param creditCardId
	 * String
	 * @return CreditCard
	 * @throws PayPalRESTException
	 */
	public static CreditCard get(APIContext apiContext, String creditCardId) throws PayPalRESTException {
		if (creditCardId == null) {
			throw new IllegalArgumentException("creditCardId cannot be null");
		}
		Object[] parameters = new Object[] {creditCardId};
		String pattern = "v1/vault/credit-cards/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		return configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, CreditCard.class);
	}

	/**
	 * Delete the Credit Card resource for the given identifier.
	 * @deprecated Please use {@link #delete(APIContext)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @throws PayPalRESTException
	 */
	public void delete(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		delete(apiContext);
		return;
	}

	/**
	 * Delete the Credit Card resource for the given identifier.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @throws PayPalRESTException
	 */
	public void delete(APIContext apiContext) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		apiContext.setMaskRequestId(true);
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/vault/credit-cards/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		configureAndExecute(apiContext, HttpMethod.DELETE, resourcePath, payLoad, null);
		return;
	}

	/**
	 * Update information in a previously saved card. Only the modified fields need to be passed in the request.
	 * @deprecated Please use {@link #update(APIContext, List)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param patchRequest
	 * List<Patch>
	 * @return CreditCard
	 * @throws PayPalRESTException
	 */
	public CreditCard update(String accessToken, List<Patch> patchRequest) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return update(apiContext, patchRequest);
	}

	/**
	 * Update information in a previously saved card. Only the modified fields need to be passed in the request.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param patchRequest
	 * List<Patch>
	 * @return CreditCard
	 * @throws PayPalRESTException
	 */
	public CreditCard update(APIContext apiContext, List<Patch> patchRequest) throws PayPalRESTException {
		if (patchRequest == null) {
			throw new IllegalArgumentException("patchRequest cannot be null");
		}
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/vault/credit-cards/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = new GsonBuilder().create().toJson(patchRequest);
		return configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, CreditCard.class);
	}

	/**
	 * Retrieves a list of Credit Card resources.
	 * @deprecated Please use {@link #list(APIContext, Map)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param containerMap
	 * Map<String, String>. See https://developer.paypal.com/webapps/developer/docs/api/#list-credit-card-resources
	 * @return CreditCardHistory
	 * @throws PayPalRESTException
	 */
	public static CreditCardHistory list(String accessToken, Map<String, String> containerMap) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return list(apiContext, containerMap);
	}

	/**
	 * Retrieves a list of Credit Card resources.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param containerMap
	 * Map<String, String>. See https://developer.paypal.com/webapps/developer/docs/api/#list-credit-card-resources
	 * @return CreditCardHistory
	 * @throws PayPalRESTException
	 */
	public static CreditCardHistory list(APIContext apiContext, Map<String, String> containerMap) throws PayPalRESTException {
		if (containerMap == null) {
			throw new IllegalArgumentException("containerMap cannot be null");
		}
		Object[] parameters = new Object[] {containerMap};
		String pattern = "v1/vault/credit-cards?merchant_id={0}&external_card_id={1}&external_customer_id={2}&start_time={3}&end_time={4}&page={5}&page_size={6}&sort_order={7}&sort_by={8}&total_required={9}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		CreditCardHistory creditCardHistory = configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, CreditCardHistory.class);
		return creditCardHistory;
	}

	/**
	 * Retrieves a list of Credit Card resources. containerMap (filters) are set to defaults.
	 * @deprecated Please use {@link #list(APIContext, Map)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @return CreditCardHistory
	 * @throws PayPalRESTException
	 */
	public static CreditCardHistory list(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		Map<String, String> parameters = new HashMap<String, String>();
		parameters.put("merchant_id", "");
		parameters.put("external_card_id", "");
		parameters.put("external_customer_id", "");
		parameters.put("start_time", "");
		parameters.put("end_time", "");
		parameters.put("page", "1");
		parameters.put("page_size", "10");
		parameters.put("sort_order", "asc");
		parameters.put("sort_by", "create_time");
		parameters.put("total_required", "true");
		return list(apiContext, parameters);
	}

	/**
	 * ID of the credit card being saved for later use.
	 */
	@java.lang.SuppressWarnings("all")
	public String getId() {
		return this.id;
	}

	/**
	 * Card number.
	 */
	@java.lang.SuppressWarnings("all")
	public String getNumber() {
		return this.number;
	}

	/**
	 * Type of the Card (eg. Visa, Mastercard, etc.).
	 */
	@java.lang.SuppressWarnings("all")
	public String getType() {
		return this.type;
	}

	/**
	 * 2 digit card expiry month.
	 */
	@java.lang.SuppressWarnings("all")
	public int getExpireMonth() {
		return this.expireMonth;
	}

	/**
	 * 4 digit card expiry year
	 */
	@java.lang.SuppressWarnings("all")
	public int getExpireYear() {
		return this.expireYear;
	}

	/**
	 * Card holder's first name.
	 */
	@java.lang.SuppressWarnings("all")
	public String getFirstName() {
		return this.firstName;
	}

	/**
	 * Card holder's last name.
	 */
	@java.lang.SuppressWarnings("all")
	public String getLastName() {
		return this.lastName;
	}

	/**
	 * Billing Address associated with this card.
	 */
	@java.lang.SuppressWarnings("all")
	public Address getBillingAddress() {
		return this.billingAddress;
	}

	/**
	 * A unique identifier of the customer to whom this bank account belongs to. Generated and provided by the facilitator. This is required when creating or using a stored funding instrument in vault.
	 */
	@java.lang.SuppressWarnings("all")
	public String getExternalCustomerId() {
		return this.externalCustomerId;
	}

	/**
	 * State of the funding instrument.
	 */
	@java.lang.SuppressWarnings("all")
	public String getState() {
		return this.state;
	}

	/**
	 * Date/Time until this resource can be used to fund a payment.
	 */
	@java.lang.SuppressWarnings("all")
	public String getValidUntil() {
		return this.validUntil;
	}

	/**
	 */
	@java.lang.SuppressWarnings("all")
	public List<Links> getLinks() {
		return this.links;
	}

	/**
	 * Payer ID
	 */
	@java.lang.SuppressWarnings("all")
	public String getPayerId() {
		return this.payerId;
	}

	/**
	 * ID of the credit card being saved for later use.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setId(final String id) {
		this.id = id;
		return this;
	}

	/**
	 * Card number.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setNumber(final String number) {
		this.number = number;
		return this;
	}

	/**
	 * Type of the Card (eg. Visa, Mastercard, etc.).
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setType(final String type) {
		this.type = type;
		return this;
	}

	/**
	 * 2 digit card expiry month.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setExpireMonth(final int expireMonth) {
		this.expireMonth = expireMonth;
		return this;
	}

	/**
	 * 4 digit card expiry year
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setExpireYear(final int expireYear) {
		this.expireYear = expireYear;
		return this;
	}

	/**
	 * Card validation code. Only supported when making a Payment but not when saving a credit card for future use.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setCvv2(final Integer cvv2) {
		this.cvv2 = cvv2;
		return this;
	}

	/**
	 * Card holder's first name.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setFirstName(final String firstName) {
		this.firstName = firstName;
		return this;
	}

	/**
	 * Card holder's last name.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setLastName(final String lastName) {
		this.lastName = lastName;
		return this;
	}

	/**
	 * Billing Address associated with this card.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setBillingAddress(final Address billingAddress) {
		this.billingAddress = billingAddress;
		return this;
	}

	/**
	 * A unique identifier of the customer to whom this bank account belongs to. Generated and provided by the facilitator. This is required when creating or using a stored funding instrument in vault.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setExternalCustomerId(final String externalCustomerId) {
		this.externalCustomerId = externalCustomerId;
		return this;
	}

	/**
	 * State of the funding instrument.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setState(final String state) {
		this.state = state;
		return this;
	}

	/**
	 * Date/Time until this resource can be used to fund a payment.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setValidUntil(final String validUntil) {
		this.validUntil = validUntil;
		return this;
	}

	/**
	 *
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setLinks(final List<Links> links) {
		this.links = links;
		return this;
	}

	/**
	 * Payer ID
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public CreditCard setPayerId(final String payerId) {
		this.payerId = payerId;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof CreditCard)) return false;
		final CreditCard other = (CreditCard) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		if (!super.equals(o)) return false;
		final java.lang.Object this$id = this.getId();
		final java.lang.Object other$id = other.getId();
		if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
		final java.lang.Object this$number = this.getNumber();
		final java.lang.Object other$number = other.getNumber();
		if (this$number == null ? other$number != null : !this$number.equals(other$number)) return false;
		final java.lang.Object this$type = this.getType();
		final java.lang.Object other$type = other.getType();
		if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
		if (this.getExpireMonth() != other.getExpireMonth()) return false;
		if (this.getExpireYear() != other.getExpireYear()) return false;
		if (this.getCvv2() != other.getCvv2()) return false;
		final java.lang.Object this$firstName = this.getFirstName();
		final java.lang.Object other$firstName = other.getFirstName();
		if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) return false;
		final java.lang.Object this$lastName = this.getLastName();
		final java.lang.Object other$lastName = other.getLastName();
		if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) return false;
		final java.lang.Object this$billingAddress = this.getBillingAddress();
		final java.lang.Object other$billingAddress = other.getBillingAddress();
		if (this$billingAddress == null ? other$billingAddress != null : !this$billingAddress.equals(other$billingAddress)) return false;
		final java.lang.Object this$externalCustomerId = this.getExternalCustomerId();
		final java.lang.Object other$externalCustomerId = other.getExternalCustomerId();
		if (this$externalCustomerId == null ? other$externalCustomerId != null : !this$externalCustomerId.equals(other$externalCustomerId)) return false;
		final java.lang.Object this$state = this.getState();
		final java.lang.Object other$state = other.getState();
		if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
		final java.lang.Object this$validUntil = this.getValidUntil();
		final java.lang.Object other$validUntil = other.getValidUntil();
		if (this$validUntil == null ? other$validUntil != null : !this$validUntil.equals(other$validUntil)) return false;
		final java.lang.Object this$links = this.getLinks();
		final java.lang.Object other$links = other.getLinks();
		if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
		final java.lang.Object this$payerId = this.getPayerId();
		final java.lang.Object other$payerId = other.getPayerId();
		if (this$payerId == null ? other$payerId != null : !this$payerId.equals(other$payerId)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof CreditCard;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + super.hashCode();
		final java.lang.Object $id = this.getId();
		result = result * PRIME + ($id == null ? 43 : $id.hashCode());
		final java.lang.Object $number = this.getNumber();
		result = result * PRIME + ($number == null ? 43 : $number.hashCode());
		final java.lang.Object $type = this.getType();
		result = result * PRIME + ($type == null ? 43 : $type.hashCode());
		result = result * PRIME + this.getExpireMonth();
		result = result * PRIME + this.getExpireYear();
		result = result * PRIME + this.getCvv2();
		final java.lang.Object $firstName = this.getFirstName();
		result = result * PRIME + ($firstName == null ? 43 : $firstName.hashCode());
		final java.lang.Object $lastName = this.getLastName();
		result = result * PRIME + ($lastName == null ? 43 : $lastName.hashCode());
		final java.lang.Object $billingAddress = this.getBillingAddress();
		result = result * PRIME + ($billingAddress == null ? 43 : $billingAddress.hashCode());
		final java.lang.Object $externalCustomerId = this.getExternalCustomerId();
		result = result * PRIME + ($externalCustomerId == null ? 43 : $externalCustomerId.hashCode());
		final java.lang.Object $state = this.getState();
		result = result * PRIME + ($state == null ? 43 : $state.hashCode());
		final java.lang.Object $validUntil = this.getValidUntil();
		result = result * PRIME + ($validUntil == null ? 43 : $validUntil.hashCode());
		final java.lang.Object $links = this.getLinks();
		result = result * PRIME + ($links == null ? 43 : $links.hashCode());
		final java.lang.Object $payerId = this.getPayerId();
		result = result * PRIME + ($payerId == null ? 43 : $payerId.hashCode());
		return result;
	}
}
