// Generated by delombok at Wed Jul 13 11:59:21 CDT 2016
package com.paypal.api.payments;

import com.paypal.base.rest.*;
import java.util.List;

public class Webhook extends PayPalResource {
	/**
	 * Identifier of the webhook resource.
	 */
	private String id;
	/**
	 * Webhook notification endpoint url.
	 */
	private String url;
	/**
	 * List of Webhooks event-types.
	 */
	private List<EventType> eventTypes;
	/**
	 * Hateoas Links.
	 */
	private List<Links> links;

	/**
	 * Default Constructor
	 */
	public Webhook() {
	}

	/**
	 * Parameterized Constructor
	 */
	public Webhook(String url, List<EventType> eventTypes) {
		this.url = url;
		this.eventTypes = eventTypes;
	}

	/**
	 * Creates the Webhook for the application associated with the access token.
	 * @deprecated Please use {@link #create(APIContext, Webhook)} instead.
	 *
	 * @param accessToken
	 * Access Token used for the API call.	
	 * @param webhook
	 * Webhook Request
	 * @return Webhook
	 * @throws PayPalRESTException
	 */
	public Webhook create(String accessToken, Webhook webhook) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return create(apiContext, webhook);
	}

	/**
	 * Creates the Webhook for the application associated with the access token.
	 * @param apiContext
	 * {@link APIContext} used for the API call.	 
	 * @param webhook
	 * Webhook Request
	 * @return Webhook
	 * @throws PayPalRESTException
	 */
	public Webhook create(APIContext apiContext, Webhook webhook) throws PayPalRESTException {
		if (webhook == null) {
			throw new IllegalArgumentException("webhook cannot be null");
		}
		Object[] parameters = new Object[] {};
		String pattern = "v1/notifications/webhooks";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = webhook.toJSON();
		return configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Webhook.class);
	}

	/**
	 * Retrieves the Webhook identified by webhook_id for the application associated with access token.
	 * @deprecated Please use {@link #get(APIContext, String)} instead.
	 *
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param webhookId
	 * Identifier of the webhook
	 * @return Webhook
	 * @throws PayPalRESTException
	 */
	public Webhook get(String accessToken, String webhookId) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return get(apiContext, webhookId);
	}

	/**
	 * Retrieves the Webhook identified by webhook_id for the application associated with access token.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param webhookId
	 * Identifier of the webhook
	 * @return Webhook
	 * @throws PayPalRESTException
	 */
	public Webhook get(APIContext apiContext, String webhookId) throws PayPalRESTException {
		if (webhookId == null) {
			throw new IllegalArgumentException("webhookId cannot be null");
		}
		Object[] parameters = new Object[] {webhookId};
		String pattern = "v1/notifications/webhooks/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		return configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Webhook.class);
	}

	/**
	 * Updates the Webhook identified by webhook_id for the application associated with access token.
	 * @deprecated Please use {@link #update(APIContext, String, String)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param webhookId
	 * Identifier of the webhook
	 * @param patchRequest
	 * patchRequest
	 * @return Webhook
	 * @throws PayPalRESTException
	 */
	public Webhook update(String accessToken, String webhookId, String patchRequest) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return update(apiContext, webhookId, patchRequest);
	}

	/**
	 * Updates the Webhook identified by webhook_id for the application associated with access token.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param webhookId
	 * Identifier of the webhook
	 * @return Webhook
	 * @throws PayPalRESTException
	 */
	public Webhook update(APIContext apiContext, String webhookId, String patchRequest) throws PayPalRESTException {
		if (webhookId == null) {
			throw new IllegalArgumentException("webhookId cannot be null");
		}
		if (patchRequest == null) {
			throw new IllegalArgumentException("patchRequest cannot be null");
		}
		Object[] parameters = new Object[] {webhookId};
		String pattern = "v1/notifications/webhooks/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = patchRequest;
		return configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, Webhook.class);
	}

	/**
	 * Deletes the Webhook identified by webhook_id for the application associated with access token.
	 * @deprecated Please use {@link #delete(APIContext, String)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param webhookId
	 * Identifier of the webhook
	 * @throws PayPalRESTException
	 */
	public void delete(String accessToken, String webhookId) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		delete(apiContext, webhookId);
	}

	/**
	 * Deletes the Webhook identified by webhook_id for the application associated with access token.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param webhookId
	 * Identifier of the webhook
	 * @throws PayPalRESTException
	 */
	public void delete(APIContext apiContext, String webhookId) throws PayPalRESTException {
		if (webhookId == null) {
			throw new IllegalArgumentException("webhookId cannot be null");
		}
		Object[] parameters = new Object[] {webhookId};
		String pattern = "v1/notifications/webhooks/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		configureAndExecute(apiContext, HttpMethod.DELETE, resourcePath, payLoad, null);
	}

	/**
	 * Identifier of the webhook resource.
	 */
	@java.lang.SuppressWarnings("all")
	public String getId() {
		return this.id;
	}

	/**
	 * Webhook notification endpoint url.
	 */
	@java.lang.SuppressWarnings("all")
	public String getUrl() {
		return this.url;
	}

	/**
	 * List of Webhooks event-types.
	 */
	@java.lang.SuppressWarnings("all")
	public List<EventType> getEventTypes() {
		return this.eventTypes;
	}

	/**
	 * Hateoas Links.
	 */
	@java.lang.SuppressWarnings("all")
	public List<Links> getLinks() {
		return this.links;
	}

	/**
	 * Identifier of the webhook resource.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Webhook setId(final String id) {
		this.id = id;
		return this;
	}

	/**
	 * Webhook notification endpoint url.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Webhook setUrl(final String url) {
		this.url = url;
		return this;
	}

	/**
	 * List of Webhooks event-types.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Webhook setEventTypes(final List<EventType> eventTypes) {
		this.eventTypes = eventTypes;
		return this;
	}

	/**
	 * Hateoas Links.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Webhook setLinks(final List<Links> links) {
		this.links = links;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof Webhook)) return false;
		final Webhook other = (Webhook) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		if (!super.equals(o)) return false;
		final java.lang.Object this$id = this.getId();
		final java.lang.Object other$id = other.getId();
		if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
		final java.lang.Object this$url = this.getUrl();
		final java.lang.Object other$url = other.getUrl();
		if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
		final java.lang.Object this$eventTypes = this.getEventTypes();
		final java.lang.Object other$eventTypes = other.getEventTypes();
		if (this$eventTypes == null ? other$eventTypes != null : !this$eventTypes.equals(other$eventTypes)) return false;
		final java.lang.Object this$links = this.getLinks();
		final java.lang.Object other$links = other.getLinks();
		if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof Webhook;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + super.hashCode();
		final java.lang.Object $id = this.getId();
		result = result * PRIME + ($id == null ? 43 : $id.hashCode());
		final java.lang.Object $url = this.getUrl();
		result = result * PRIME + ($url == null ? 43 : $url.hashCode());
		final java.lang.Object $eventTypes = this.getEventTypes();
		result = result * PRIME + ($eventTypes == null ? 43 : $eventTypes.hashCode());
		final java.lang.Object $links = this.getLinks();
		result = result * PRIME + ($links == null ? 43 : $links.hashCode());
		return result;
	}
}
