/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Links;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.List;

public class Refund
extends PayPalResource {
    private String id;
    private Amount amount;
    private String state;
    private String reason;
    private String saleId;
    private String captureId;
    private String parentPayment;
    private String description;
    private String createTime;
    private String updateTime;
    private List<Links> links;

    public static Refund get(String accessToken, String refundId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Refund.get(apiContext, refundId);
    }

    public static Refund get(APIContext apiContext, String refundId) throws PayPalRESTException {
        if (refundId == null) {
            throw new IllegalArgumentException("refundId cannot be null");
        }
        Object[] parameters = new Object[]{refundId};
        String pattern = "v1/payments/refund/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Refund.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Refund.class);
    }

    public String getId() {
        return this.id;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public String getState() {
        return this.state;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSaleId() {
        return this.saleId;
    }

    public String getCaptureId() {
        return this.captureId;
    }

    public String getParentPayment() {
        return this.parentPayment;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Refund setId(String id) {
        this.id = id;
        return this;
    }

    public Refund setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Refund setState(String state) {
        this.state = state;
        return this;
    }

    public Refund setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public Refund setSaleId(String saleId) {
        this.saleId = saleId;
        return this;
    }

    public Refund setCaptureId(String captureId) {
        this.captureId = captureId;
        return this;
    }

    public Refund setParentPayment(String parentPayment) {
        this.parentPayment = parentPayment;
        return this;
    }

    public Refund setDescription(String description) {
        this.description = description;
        return this;
    }

    public Refund setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public Refund setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public Refund setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Refund)) {
            return false;
        }
        Refund other = (Refund)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Amount this$amount = this.getAmount();
        Amount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$saleId = this.getSaleId();
        String other$saleId = other.getSaleId();
        if (this$saleId == null ? other$saleId != null : !this$saleId.equals(other$saleId)) {
            return false;
        }
        String this$captureId = this.getCaptureId();
        String other$captureId = other.getCaptureId();
        if (this$captureId == null ? other$captureId != null : !this$captureId.equals(other$captureId)) {
            return false;
        }
        String this$parentPayment = this.getParentPayment();
        String other$parentPayment = other.getParentPayment();
        if (this$parentPayment == null ? other$parentPayment != null : !this$parentPayment.equals(other$parentPayment)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        List<Links> this$links = this.getLinks();
        List<Links> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Refund;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Amount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $saleId = this.getSaleId();
        result = result * 59 + ($saleId == null ? 43 : $saleId.hashCode());
        String $captureId = this.getCaptureId();
        result = result * 59 + ($captureId == null ? 43 : $captureId.hashCode());
        String $parentPayment = this.getParentPayment();
        result = result * 59 + ($parentPayment == null ? 43 : $parentPayment.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        List<Links> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }
}

