/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Currency;
import com.paypal.api.payments.Links;
import com.paypal.api.payments.Refund;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.List;

public class Capture
extends PayPalResource {
    private String id;
    private Amount amount;
    private Boolean isFinalCapture;
    private String state;
    private String parentPayment;
    private Currency transactionFee;
    private String createTime;
    private String updateTime;
    private List<Links> links;

    public static Capture get(String accessToken, String captureId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Capture.get(apiContext, captureId);
    }

    public static Capture get(APIContext apiContext, String captureId) throws PayPalRESTException {
        if (captureId == null) {
            throw new IllegalArgumentException("captureId cannot be null");
        }
        Object[] parameters = new Object[]{captureId};
        String pattern = "v1/payments/capture/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Capture.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Capture.class);
    }

    public Refund refund(String accessToken, Refund refund) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.refund(apiContext, refund);
    }

    public Refund refund(APIContext apiContext, Refund refund) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (refund == null) {
            throw new IllegalArgumentException("refund cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/capture/{0}/refund";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = refund.toJSON();
        return Capture.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Refund.class);
    }

    public String getId() {
        return this.id;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Boolean getIsFinalCapture() {
        return this.isFinalCapture;
    }

    public String getState() {
        return this.state;
    }

    public String getParentPayment() {
        return this.parentPayment;
    }

    public Currency getTransactionFee() {
        return this.transactionFee;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Capture setId(String id) {
        this.id = id;
        return this;
    }

    public Capture setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Capture setIsFinalCapture(Boolean isFinalCapture) {
        this.isFinalCapture = isFinalCapture;
        return this;
    }

    public Capture setState(String state) {
        this.state = state;
        return this;
    }

    public Capture setParentPayment(String parentPayment) {
        this.parentPayment = parentPayment;
        return this;
    }

    public Capture setTransactionFee(Currency transactionFee) {
        this.transactionFee = transactionFee;
        return this;
    }

    public Capture setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public Capture setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public Capture setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Capture)) {
            return false;
        }
        Capture other = (Capture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Amount this$amount = this.getAmount();
        Amount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Boolean this$isFinalCapture = this.getIsFinalCapture();
        Boolean other$isFinalCapture = other.getIsFinalCapture();
        if (this$isFinalCapture == null ? other$isFinalCapture != null : !((Object)this$isFinalCapture).equals(other$isFinalCapture)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$parentPayment = this.getParentPayment();
        String other$parentPayment = other.getParentPayment();
        if (this$parentPayment == null ? other$parentPayment != null : !this$parentPayment.equals(other$parentPayment)) {
            return false;
        }
        Currency this$transactionFee = this.getTransactionFee();
        Currency other$transactionFee = other.getTransactionFee();
        if (this$transactionFee == null ? other$transactionFee != null : !((Object)this$transactionFee).equals(other$transactionFee)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        List<Links> this$links = this.getLinks();
        List<Links> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Capture;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Amount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Boolean $isFinalCapture = this.getIsFinalCapture();
        result = result * 59 + ($isFinalCapture == null ? 43 : ((Object)$isFinalCapture).hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $parentPayment = this.getParentPayment();
        result = result * 59 + ($parentPayment == null ? 43 : $parentPayment.hashCode());
        Currency $transactionFee = this.getTransactionFee();
        result = result * 59 + ($transactionFee == null ? 43 : ((Object)$transactionFee).hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        List<Links> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }
}

