/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor;

import com.pcistudio.task.procesor.HandlerWriteProperties;
import com.pcistudio.task.procesor.handler.TaskHandler;
import com.pcistudio.task.procesor.util.Assert;
import com.pcistudio.task.procesor.util.GenericTypeUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@Immutable
public final class HandlerProperties
extends HandlerWriteProperties {
    private final int maxRetries;
    private final int retryDelayMs;
    private final boolean exponentialBackoff;
    private final int maxPoll;
    private final int pollInterval;
    private final int requeueInterval;
    private final int taskExecutionTimeout;
    private final int longTaskTimeMs;
    private final int longTaskCheckIntervalMs;
    private final int longTaskCheckInitialDelayMs;
    private final int maxParallelTasks;
    private final Set<Class<? extends RuntimeException>> transientExceptions;
    private final Duration processingExpire;
    private final Duration processingGracePeriod;
    private final TaskHandler taskHandler;
    private final Class<?> taskHandlerType;
    private final boolean autoStartEnabled;

    private HandlerProperties(HandlerPropertiesBuilder builder) {
        super(builder);
        this.maxRetries = builder.maxRetries;
        this.retryDelayMs = builder.retryDelayMs;
        this.exponentialBackoff = builder.exponentialBackoff;
        this.maxPoll = builder.maxPoll;
        this.pollInterval = builder.pollInterval;
        this.requeueInterval = builder.requeueInterval;
        this.taskExecutionTimeout = builder.taskExecutionTimeout;
        this.longTaskTimeMs = builder.longTaskTimeMs;
        this.longTaskCheckIntervalMs = builder.longTaskCheckIntervalMs;
        this.longTaskCheckInitialDelayMs = builder.longTaskCheckInitialDelayMs;
        this.maxParallelTasks = builder.maxParallelTasks;
        this.processingExpire = builder.processingExpire;
        this.processingGracePeriod = builder.processingGracePeriod;
        this.taskHandler = Objects.requireNonNull(builder.taskHandler, "TaskHandler cannot be null");
        this.taskHandlerType = Objects.requireNonNull(builder.taskHandlerType, "TaskHandlerType cannot be null");
        this.autoStartEnabled = builder.autoStartEnabled;
        this.transientExceptions = Objects.requireNonNullElse(builder.transientExceptions, Collections.emptySet());
    }

    public static HandlerPropertiesBuilder builder() {
        return new HandlerPropertiesBuilder();
    }

    public Set<Class<? extends RuntimeException>> getTransientExceptions() {
        return new HashSet<Class<? extends RuntimeException>>(this.transientExceptions);
    }

    @Generated
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Generated
    public int getRetryDelayMs() {
        return this.retryDelayMs;
    }

    @Generated
    public boolean isExponentialBackoff() {
        return this.exponentialBackoff;
    }

    @Generated
    public int getMaxPoll() {
        return this.maxPoll;
    }

    @Generated
    public int getPollInterval() {
        return this.pollInterval;
    }

    @Generated
    public int getRequeueInterval() {
        return this.requeueInterval;
    }

    @Generated
    public int getTaskExecutionTimeout() {
        return this.taskExecutionTimeout;
    }

    @Generated
    public int getLongTaskTimeMs() {
        return this.longTaskTimeMs;
    }

    @Generated
    public int getLongTaskCheckIntervalMs() {
        return this.longTaskCheckIntervalMs;
    }

    @Generated
    public int getLongTaskCheckInitialDelayMs() {
        return this.longTaskCheckInitialDelayMs;
    }

    @Generated
    public int getMaxParallelTasks() {
        return this.maxParallelTasks;
    }

    @Generated
    public Duration getProcessingExpire() {
        return this.processingExpire;
    }

    @Generated
    public Duration getProcessingGracePeriod() {
        return this.processingGracePeriod;
    }

    @Generated
    public TaskHandler getTaskHandler() {
        return this.taskHandler;
    }

    @Generated
    public Class<?> getTaskHandlerType() {
        return this.taskHandlerType;
    }

    @Generated
    public boolean isAutoStartEnabled() {
        return this.autoStartEnabled;
    }

    public static class HandlerPropertiesBuilder
    extends HandlerWriteProperties.HandlerWritePropertiesBuilder<HandlerPropertiesBuilder> {
        private int maxRetries = 3;
        private int retryDelayMs = 1000;
        private boolean exponentialBackoff = false;
        private int maxPoll = 16;
        private int pollInterval = 60000;
        private int requeueInterval = 300000;
        private int taskExecutionTimeout = 180000;
        private int longTaskTimeMs = 180000;
        private int longTaskCheckIntervalMs = 60000;
        private int longTaskCheckInitialDelayMs = 60000;
        private int maxParallelTasks = 1;
        private Duration processingExpire = Duration.ofMinutes(5L);
        private Duration processingGracePeriod = Duration.ofMinutes(0L);
        @Nullable
        private TaskHandler taskHandler;
        @Nullable
        private Class<?> taskHandlerType;
        private boolean autoStartEnabled = true;
        @Nullable
        private Set<Class<? extends RuntimeException>> transientExceptions;

        public HandlerPropertiesBuilder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public HandlerPropertiesBuilder retryDelayMs(int retryDelayMs) {
            this.retryDelayMs = retryDelayMs;
            return this;
        }

        public HandlerPropertiesBuilder exponentialBackoff(boolean exponentialBackoff) {
            this.exponentialBackoff = exponentialBackoff;
            return this;
        }

        public HandlerPropertiesBuilder maxPoll(int maxPoll) {
            this.maxPoll = maxPoll;
            return this;
        }

        public HandlerPropertiesBuilder pollInterval(int pollInterval) {
            this.pollInterval = pollInterval;
            return this;
        }

        public HandlerPropertiesBuilder requeueInterval(int requeueInterval) {
            this.requeueInterval = requeueInterval;
            return this;
        }

        public HandlerPropertiesBuilder taskExecutionTimeout(int taskExecutionTimeout) {
            this.taskExecutionTimeout = taskExecutionTimeout;
            return this;
        }

        public HandlerPropertiesBuilder maxParallelTasks(int maxParallelTasks) {
            this.maxParallelTasks = maxParallelTasks;
            return this;
        }

        public HandlerPropertiesBuilder processingExpire(Duration processingExpire) {
            this.processingExpire = processingExpire;
            return this;
        }

        public HandlerPropertiesBuilder processingGracePeriod(Duration processingGracePeriod) {
            this.processingGracePeriod = processingGracePeriod;
            return this;
        }

        public HandlerPropertiesBuilder taskHandler(TaskHandler taskHandler) {
            this.taskHandler = taskHandler;
            return this;
        }

        public HandlerPropertiesBuilder taskHandlerType(Class<?> taskHandlerType) {
            this.taskHandlerType = taskHandlerType;
            return this;
        }

        public HandlerPropertiesBuilder autoStartEnabled(boolean autoStartEnabled) {
            this.autoStartEnabled = autoStartEnabled;
            return this;
        }

        public HandlerPropertiesBuilder transientExceptions(Set<Class<? extends RuntimeException>> transientExceptions) {
            this.transientExceptions = transientExceptions == null ? Collections.emptySet() : Collections.unmodifiableSet(transientExceptions);
            return this;
        }

        @Override
        public HandlerProperties build() {
            Assert.notNull(this.taskHandler, "TaskHandler cannot be null");
            this.taskHandlerType = this.discoverTaskHandlerType(this.taskHandler);
            return new HandlerProperties(this);
        }

        private Class<?> discoverTaskHandlerType(TaskHandler taskHandler) {
            try {
                return GenericTypeUtil.getGenericTypeFromInterface(taskHandler.getClass(), TaskHandler.class);
            }
            catch (RuntimeException ex) {
                Assert.notNull(this.taskHandlerType, "TaskHandlerType cannot be discover. It can be set manually using taskHandlerType when registering the task ");
                return this.taskHandlerType;
            }
        }
    }
}

