/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.page;

import com.pcistudio.task.procesor.page.Cursor;
import com.pcistudio.task.procesor.page.Pageable;
import com.pcistudio.task.procesor.util.Assert;
import com.pcistudio.task.procesor.util.GenericTypeUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CursorPageableFactory<ITEM, OFFSET> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CursorPageableFactory.class);
    protected final Class<OFFSET> offsetClass = GenericTypeUtil.getGenericTypeFromSuperclass(this.getClass(), 1);

    public Pageable<ITEM> createPageable(BiFunction<Cursor<OFFSET>, Integer, List<ITEM>> resultFunc, int maxSize, String token) {
        Assert.notNull(resultFunc, "resultFunc must not be null");
        List<ITEM> result = resultFunc.apply(this.decodeCursor(token), maxSize);
        return this.createPageable(result, maxSize);
    }

    public Pageable<ITEM> createPageable(List<ITEM> result, int maxSize) {
        Assert.notNull(result, "result must not be null");
        Assert.isTrue(maxSize > 0, "maxSize must be greater than 0");
        if (result.size() < maxSize) {
            return new Pageable<ITEM>(result, null);
        }
        ITEM lastElement = result.get(result.size() - 1);
        if (log.isTraceEnabled() && result.size() > 1) {
            Cursor<OFFSET> cursor = this.createCursor(result.get(0));
            log.trace("First element offset={}, id={}", cursor.offset(), (Object)cursor.id());
            log.trace("Number of elements={}", (Object)result.size());
        }
        return new Pageable<ITEM>(result, this.generateToken(lastElement));
    }

    @Nullable
    public Cursor<OFFSET> decodeCursor(@Nullable String token) {
        if (token == null || token.isBlank()) {
            return null;
        }
        return this.decode(token);
    }

    protected String generateToken(ITEM lastElement) {
        Assert.notNull(lastElement, "lastElement must not be null");
        Cursor<OFFSET> cursor = this.createCursor(lastElement);
        if (log.isTraceEnabled()) {
            log.trace("Last element offset={}, id={}", cursor.offset(), (Object)cursor.id());
        }
        return this.encode(cursor);
    }

    protected abstract String encode(Cursor<OFFSET> var1);

    protected abstract Cursor<OFFSET> decode(String var1);

    protected abstract Cursor<OFFSET> createCursor(ITEM var1);
}

