/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.page;

import com.pcistudio.task.procesor.page.Pageable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageableReader<T>
implements Iterable<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageableReader.class);
    private final Function<String, Pageable<T>> reader;
    private static final int MAX_PAGE_SIZE = 100000;

    public List<T> readAll() {
        ArrayList<T> results = new ArrayList<T>();
        Pageable<T> pageable = this.reader.apply(null);
        results.addAll(pageable.results());
        int page = 1;
        while (!pageable.finished()) {
            pageable = this.reader.apply(pageable.nextPageToken());
            results.addAll(pageable.results());
            ++page;
            if (log.isDebugEnabled()) {
                log.debug("found {} items in page={}", (Object)pageable.results().size(), (Object)page);
            }
            if (results.size() <= 100000) continue;
            if (log.isWarnEnabled()) {
                log.warn("page size is too big: {}", (Object)pageable.results().size());
            }
            return results;
        }
        if (log.isInfoEnabled()) {
            log.info("read: {} items", (Object)results.size());
        }
        return results;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Pageable<T> pageable;
            private Iterator<T> iterator;
            {
                this.pageable = PageableReader.this.reader.apply(null);
                this.iterator = this.pageable.results().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.iterator.hasNext()) {
                    return true;
                }
                if (this.pageable.finished()) {
                    return false;
                }
                this.pageable = PageableReader.this.reader.apply(this.pageable.nextPageToken());
                this.iterator = this.pageable.results().iterator();
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                return this.iterator.next();
            }
        };
    }

    @Generated
    public PageableReader(Function<String, Pageable<T>> reader) {
        this.reader = reader;
    }
}

