/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.task;

import com.pcistudio.task.procesor.task.ProcessStatus;
import com.pcistudio.task.procesor.task.TaskInfoOperations;
import com.pcistudio.task.procesor.util.Assert;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public final class TaskInfo
implements TaskInfoOperations {
    @Nullable
    private Long id;
    @Nullable
    private UUID batchId;
    private ProcessStatus status;
    private Instant executionTime;
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    private transient byte[] payloadBytes;
    private String handlerName;
    @Nullable
    private String partitionId;
    @Nullable
    private String objectType;
    private Long version;
    @Nullable
    private Instant createdAt;
    @Nullable
    private Instant updatedAt;
    private int retryCount;

    private TaskInfo(TaskInfoBuilder taskInfoBuilder) {
        this.id = taskInfoBuilder.id;
        this.batchId = taskInfoBuilder.batchId;
        this.status = Objects.requireNonNull(taskInfoBuilder.status, "status must not be null");
        this.executionTime = Objects.requireNonNull(taskInfoBuilder.executionTime, "executionTime must not be null");
        this.payloadBytes = Objects.requireNonNull(taskInfoBuilder.payloadBytes, "payloadBytes must not be null");
        this.handlerName = Objects.requireNonNull(taskInfoBuilder.handlerName, "handlerName must not be null");
        this.partitionId = taskInfoBuilder.partitionId;
        this.objectType = taskInfoBuilder.objectType;
        this.version = Objects.requireNonNull(taskInfoBuilder.version, "version must not be null");
        this.createdAt = taskInfoBuilder.createdAt;
        this.updatedAt = taskInfoBuilder.updatedAt;
        this.retryCount = taskInfoBuilder.retryCount;
    }

    public void incrementRetryCount() {
        ++this.retryCount;
    }

    public void updateStatus(ProcessStatus status) {
        this.status = status;
    }

    public void updateUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void incrementVersion() {
        Long l = this.version;
        this.version = this.version + 1L;
    }

    public void setId(@Nullable Long id) {
        Assert.notNull(id, "Id must not be null");
        if (this.id != null) {
            throw new IllegalStateException("Id can only be set once");
        }
        this.id = id;
    }

    public String toString() {
        return "TaskInfo{id=" + this.id + ", batchId=" + String.valueOf(this.batchId) + ", status=" + String.valueOf((Object)this.status) + ", version=" + this.version + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", retryCount=" + this.retryCount + ", handlerName='" + this.handlerName + "', objectType='" + this.objectType + "'}";
    }

    @Override
    public void completed() {
        this.version = this.version + 1L;
        this.updateStatus(ProcessStatus.COMPLETED);
    }

    @Override
    public void markForRetry() {
        this.version = this.version + 1L;
        this.updateStatus(ProcessStatus.PENDING);
    }

    @Override
    public void failed() {
        this.version = this.version + 1L;
        this.updateStatus(ProcessStatus.FAILED);
    }

    public static TaskInfoBuilder builder() {
        return new TaskInfoBuilder();
    }

    public byte[] getPayloadBytes() {
        return (byte[])this.payloadBytes.clone();
    }

    @Override
    @Nullable
    @Generated
    public Long getId() {
        return this.id;
    }

    @Override
    @Nullable
    @Generated
    public UUID getBatchId() {
        return this.batchId;
    }

    @Override
    @Generated
    public ProcessStatus getStatus() {
        return this.status;
    }

    @Override
    @Generated
    public Instant getExecutionTime() {
        return this.executionTime;
    }

    @Override
    @Generated
    public String getHandlerName() {
        return this.handlerName;
    }

    @Override
    @Nullable
    @Generated
    public String getPartitionId() {
        return this.partitionId;
    }

    @Override
    @Nullable
    @Generated
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Nullable
    @Generated
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @Generated
    public int getRetryCount() {
        return this.retryCount;
    }

    public static class TaskInfoBuilder {
        @Nullable
        private Long id;
        @Nullable
        private UUID batchId;
        @Nullable
        private ProcessStatus status;
        @Nullable
        private Instant executionTime;
        @Nullable
        private byte[] payloadBytes;
        @Nullable
        private String handlerName;
        @Nullable
        private String partitionId;
        @Nullable
        private String objectType;
        @Nullable
        private Long version;
        @Nullable
        private Instant createdAt;
        @Nullable
        private Instant updatedAt;
        @Nullable
        private int retryCount;

        public TaskInfoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TaskInfoBuilder batchId(UUID batchId) {
            this.batchId = batchId;
            return this;
        }

        public TaskInfoBuilder status(ProcessStatus status) {
            this.status = status;
            return this;
        }

        public TaskInfoBuilder executionTime(Instant executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public TaskInfoBuilder payloadBytes(byte[] payloadBytes) {
            Assert.notNull(payloadBytes, "payloadBytes must not be null");
            this.payloadBytes = (byte[])payloadBytes.clone();
            return this;
        }

        public TaskInfoBuilder handlerName(String handlerName) {
            this.handlerName = handlerName;
            return this;
        }

        public TaskInfoBuilder partitionId(String partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public TaskInfoBuilder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        public TaskInfoBuilder version(Long version) {
            this.version = version;
            return this;
        }

        public TaskInfoBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public TaskInfoBuilder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public TaskInfoBuilder retryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public TaskInfo build() {
            return new TaskInfo(this);
        }
    }
}

