/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.task;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public final class TaskInfoError {
    @Nullable
    private UUID id;
    private final Long taskId;
    private final String partitionId;
    private final String errorMessage;
    @Nullable
    private final String handlerName;
    @Nullable
    private final Instant createdAt;
    public static final TaskInfoError EMPTY = TaskInfoError.builder().taskId(0L).errorMessage("").partitionId("").handlerName("").createdAt(Instant.MIN).build();

    public TaskInfoError(TaskInfoErrorBuilder builder) {
        this.id = Objects.requireNonNullElseGet(builder.id, UUID::randomUUID);
        this.taskId = Objects.requireNonNull(builder.taskId, "taskId must not be null");
        this.partitionId = Objects.requireNonNull(builder.partitionId, "partitionId must not be null");
        this.errorMessage = Objects.requireNonNull(builder.errorMessage, "errorMessage must not be null");
        this.handlerName = builder.handlerName;
        this.createdAt = builder.createdAt;
    }

    public static TaskInfoErrorBuilder builder() {
        return new TaskInfoErrorBuilder();
    }

    public String toString() {
        return "TaskInfoError{id=" + String.valueOf(this.id) + ", taskId=" + this.taskId + ", errorMessage='" + this.errorMessage + "'}";
    }

    @Nullable
    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public Long getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getPartitionId() {
        return this.partitionId;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    @Generated
    public String getHandlerName() {
        return this.handlerName;
    }

    @Nullable
    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public static final class TaskInfoErrorBuilder {
        @Nullable
        private UUID id;
        @Nullable
        private Long taskId;
        @Nullable
        private String partitionId;
        @Nullable
        private String errorMessage;
        @Nullable
        private String handlerName;
        @Nullable
        private Instant createdAt;

        private TaskInfoErrorBuilder() {
        }

        public TaskInfoErrorBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public TaskInfoErrorBuilder taskId(Long taskId) {
            this.taskId = taskId;
            return this;
        }

        public TaskInfoErrorBuilder partitionId(String partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public TaskInfoErrorBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public TaskInfoErrorBuilder handlerName(String handlerName) {
            this.handlerName = handlerName;
            return this;
        }

        public TaskInfoErrorBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public TaskInfoError build() {
            return new TaskInfoError(this);
        }
    }
}

