/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.task;

import com.pcistudio.task.procesor.task.ProcessStatus;
import com.pcistudio.task.procesor.task.TaskInfoError;
import com.pcistudio.task.procesor.util.ExceptionUtils;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;

public interface TaskMetadata {
    public Long getId();

    public UUID getBatchId();

    public ProcessStatus getStatus();

    public Long getVersion();

    public Instant getCreatedAt();

    public Instant getUpdatedAt();

    public Instant getExecutionTime();

    public int getRetryCount();

    public String getHandlerName();

    public String getPartitionId();

    public String getObjectType();

    default public TaskInfoError createError(String errorMessage) {
        if (errorMessage == null) {
            return TaskInfoError.EMPTY;
        }
        return TaskInfoError.builder().taskId(Objects.requireNonNull(this.getId(), "Id must not be null")).partitionId(Objects.requireNonNull(this.getPartitionId(), "PartitionId must not be null")).errorMessage(errorMessage).handlerName(Objects.requireNonNull(this.getHandlerName(), "HandlerName must not be null")).build();
    }

    default public TaskInfoError createError(Exception exception) {
        return this.createError(ExceptionUtils.getMostSpecificCause(exception).getMessage());
    }
}

