/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.util;

import edu.umd.cs.findbugs.annotations.Nullable;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    @Nullable
    public static Throwable getRootCause(Throwable original) {
        if (original == null) {
            return null;
        }
        Throwable rootCause = null;
        for (Throwable cause = original.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public static Throwable getMostSpecificCause(Throwable original) {
        Throwable rootCause = ExceptionUtils.getRootCause(original);
        return rootCause != null ? rootCause : original;
    }

    public static Throwable unwrapException(Exception exception) {
        return exception.getCause() == null ? exception : exception.getCause();
    }
}

