/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.util;

import com.pcistudio.task.procesor.util.Assert;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericTypeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericTypeUtil.class);

    private GenericTypeUtil() {
    }

    public static Class<?> getGenericTypeFromSuperclass(Class<?> clazz) {
        return GenericTypeUtil.getGenericTypeFromSuperclass(clazz, 0);
    }

    public static Class<?> getGenericTypeFromSuperclass(Class<?> clazz, int index) {
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
            Assert.isTrue(index >= 0 && index < parameterizedType.getActualTypeArguments().length, "No generic type found at index: " + index);
            return (Class)parameterizedType.getActualTypeArguments()[index];
        }
        throw new IllegalArgumentException("No ParameterizedType class=" + clazz.getCanonicalName());
    }

    public static Class<?> getGenericTypeFromInterface(Class<?> clazz, Class<?> type) {
        return GenericTypeUtil.getGenericTypeFromInterface(clazz, type, 0);
    }

    public static Class<?> getGenericTypeFromInterface(Class<?> clazz, Class<?> type, int index) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(genericInterface instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)genericInterface).getRawType() != type) continue;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            return (Class)actualTypeArguments[index];
        }
        throw new IllegalArgumentException("No generic type found at index: " + index);
    }
}

