/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.util;

import com.pcistudio.task.procesor.util.Assert;
import com.pcistudio.task.procesor.util.ClockIncreaseStrategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MutableFixedClock
extends Clock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MutableFixedClock.class);
    private final Clock baseClock;
    private boolean debug = false;
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    private ClockIncreaseStrategy clockIncreaseStrategy = new FixedClockIncreaseStrategy();
    private short speed = 1;

    private MutableFixedClock(Clock baseClock) {
        Assert.notNull(baseClock, "baseClock cannot be null");
        Assert.isFalse(baseClock instanceof MutableFixedClock, "baseClock can not be an instance of MutableFixedClock");
        this.baseClock = baseClock;
        if (log.isInfoEnabled()) {
            log.info("Clock initialized with: {}", (Object)baseClock.instant());
        }
    }

    public MutableFixedClock(Instant instant, ZoneId zone) {
        this(MutableFixedClock.fixed(instant, zone));
    }

    public MutableFixedClock(Instant instant) {
        this(instant, ZoneId.systemDefault());
    }

    public MutableFixedClock() {
        this(Instant.now());
    }

    public MutableFixedClock withDebug() {
        this.debug = true;
        return this;
    }

    public MutableFixedClock withRealTimeStrategy() {
        this.withRealTimeStrategy(new RealTimeClockIncreaseStrategy());
        return this;
    }

    public MutableFixedClock withSpeed(short speed) {
        this.speed = speed;
        return this;
    }

    public MutableFixedClock withRealTimeStrategy(ClockIncreaseStrategy clockIncreaseStrategy) {
        this.clockIncreaseStrategy = clockIncreaseStrategy;
        return this;
    }

    public void increaseTime(Duration duration) {
        this.clockIncreaseStrategy.addTime(duration);
    }

    @Override
    public Instant instant() {
        Instant instant = this.clockIncreaseStrategy.currentInstant();
        if (this.debug) {
            log.debug("Current time: {}", (Object)instant);
        }
        return instant;
    }

    @Override
    public long millis() {
        long epochMilli = this.clockIncreaseStrategy.currentInstant().toEpochMilli();
        if (this.debug) {
            log.debug("Current millis: {}", (Object)epochMilli);
        }
        return epochMilli;
    }

    @Override
    public ZoneId getZone() {
        return this.baseClock.getZone();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return this.baseClock.withZone(zone);
    }

    private final class FixedClockIncreaseStrategy
    implements ClockIncreaseStrategy {
        private final AtomicLong timeAddedMillis = new AtomicLong(0L);

        private FixedClockIncreaseStrategy() {
        }

        @Override
        public Instant currentInstant() {
            return MutableFixedClock.this.baseClock.instant().plusMillis(this.timeAddedMillis.get());
        }

        @Override
        public void addTime(Duration duration) {
            this.timeAddedMillis.addAndGet(duration.toMillis());
        }
    }

    private final class RealTimeClockIncreaseStrategy
    implements ClockIncreaseStrategy {
        private final long startTime = System.currentTimeMillis();
        private final AtomicLong timeAddedMillis = new AtomicLong(0L);

        private RealTimeClockIncreaseStrategy() {
        }

        @Override
        public Instant currentInstant() {
            long timePass = System.currentTimeMillis() - this.startTime;
            return MutableFixedClock.this.baseClock.instant().plusMillis((long)MutableFixedClock.this.speed * (timePass + this.timeAddedMillis.get()));
        }

        @Override
        public void addTime(Duration duration) {
            this.timeAddedMillis.addAndGet(duration.toMillis());
        }
    }
}

