/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.util;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public final class SymmetricEncryption {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final int TAG_BIT_LENGTH = 128;

    private SymmetricEncryption() {
    }

    private static SecretKey generateSecretKey(int keySize) throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(keySize, SECURE_RANDOM);
        return keyGen.generateKey();
    }

    private static byte[] generateIV(int ivSize) {
        byte[] iv = new byte[ivSize];
        SECURE_RANDOM.nextBytes(iv);
        return iv;
    }

    public static byte[] encrypt(String plaintext, SecretKey key, byte[] iv, byte[] aad) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)key, spec);
        cipher.updateAAD(aad);
        return cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
    }

    private static String decrypt(byte[] cipherText, SecretKey key, byte[] iv, byte[] aad) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)key, spec);
        cipher.updateAAD(aad);
        byte[] decryptedBytes = cipher.doFinal(cipherText);
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }

    public static void main(String[] args) throws Exception {
        String plaintext = "Hello, World!";
        SecretKey key = SymmetricEncryption.generateSecretKey(128);
        String aad = "user:1";
        byte[] iv = SymmetricEncryption.generateIV(12);
        byte[] encryptedBytes = SymmetricEncryption.encrypt(plaintext, key, iv, aad.getBytes(StandardCharsets.UTF_8));
        System.out.println("Encrypted Text: " + Base64.getEncoder().encodeToString(encryptedBytes));
        String decryptedText = SymmetricEncryption.decrypt(encryptedBytes, key, iv, aad.getBytes(StandardCharsets.UTF_8));
        System.out.println("Decrypted Text: " + decryptedText);
    }
}

