/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.writer;

import com.pcistudio.task.procesor.task.ProcessStatus;
import com.pcistudio.task.procesor.task.TaskInfo;
import com.pcistudio.task.procesor.task.TaskMetadata;
import com.pcistudio.task.procesor.task.TaskParams;
import com.pcistudio.task.procesor.util.encoder.MessageEncoding;
import com.pcistudio.task.procesor.writer.TaskInfoWriter;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@Immutable
public final class TaskWriter {
    private final TaskInfoWriter taskInfoWriter;
    private final MessageEncoding messageEncoding;
    private final Clock clock;

    public TaskMetadata writeTasks(TaskParams taskParams) {
        TaskInfo taskInfo = this.createTaskInfo(UUID.randomUUID(), taskParams);
        return this.taskInfoWriter.writeTasks(taskInfo);
    }

    public List<TaskMetadata> writeTasks(Collection<TaskParams> taskParamsCollection) {
        UUID batchId = UUID.randomUUID();
        List<TaskInfo> taskInfos = taskParamsCollection.stream().map(taskParams -> this.createTaskInfo(batchId, (TaskParams)taskParams)).toList();
        return this.taskInfoWriter.writeTasks(taskInfos);
    }

    private TaskInfo createTaskInfo(UUID batchId, TaskParams taskParams) {
        Instant executionTime = taskParams.getExecutionTime();
        if (executionTime == null) {
            executionTime = Instant.now(this.clock);
        }
        if (taskParams.getDelay() != null) {
            executionTime = executionTime.plus(taskParams.getDelay());
        }
        return TaskInfo.builder().payloadBytes(this.messageEncoding.encode(taskParams.getPayload())).objectType(taskParams.getPayload().getClass().getCanonicalName()).executionTime(executionTime).handlerName(taskParams.getHandlerName()).batchId(batchId).version(1L).createdAt(Instant.now(this.clock)).updatedAt(Instant.now(this.clock)).retryCount(0).status(ProcessStatus.PENDING).build();
    }

    @Generated
    public TaskWriter(TaskInfoWriter taskInfoWriter, MessageEncoding messageEncoding, Clock clock) {
        this.taskInfoWriter = taskInfoWriter;
        this.messageEncoding = messageEncoding;
        this.clock = clock;
    }
}

