/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.register;

import com.pcistudio.task.procesor.register.TaskStorageSetup;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class H2TaskStorageSetup
implements TaskStorageSetup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(H2TaskStorageSetup.class);
    private final JdbcTemplate jdbcTemplate;

    public H2TaskStorageSetup(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"})
    public void createStorage(String tableName) {
        this.jdbcTemplate.execute("CREATE TABLE IF NOT EXISTS %s (\n   id BIGINT AUTO_INCREMENT PRIMARY KEY,\n   batch_id VARCHAR(50) NOT NULL,\n   status VARCHAR(50) NOT NULL,\n   version BIGINT NOT NULL,\n   created_at TIMESTAMP NOT NULL,\n   updated_at TIMESTAMP NOT NULL,\n   execution_time TIMESTAMP NOT NULL,\n   payload BLOB NOT NULL,\n   retry_count INT NOT NULL,\n   partition_id VARCHAR(36),\n   read_token VARCHAR(36),\n   handler_name VARCHAR(70) NOT NULL,\n   object_type VARCHAR(128) NOT NULL\n);".formatted(tableName));
        this.jdbcTemplate.execute("CREATE Index IF NOT EXISTS %s_execution_time_idx ON %s (execution_time);\n".formatted(tableName, tableName));
        this.jdbcTemplate.execute("CREATE Index IF NOT EXISTS %s_updated_at_idx ON %s (updated_at);\n".formatted(tableName, tableName));
        this.jdbcTemplate.execute("CREATE Index IF NOT EXISTS %s_read_token_idx ON %s (read_token);\n".formatted(tableName, tableName));
        log.info("Table created successfully for table {}", (Object)tableName);
        String errorTableName = "%s_error".formatted(tableName);
        this.jdbcTemplate.execute("CREATE TABLE IF NOT EXISTS %s (\n   id CHAR(36) PRIMARY KEY,\n   task_id BIGINT NOT NULL,\n   partition_id VARCHAR(36),\n   error_message VARCHAR(512),\n   created_at TIMESTAMP NOT NULL,\n   FOREIGN KEY (task_id) REFERENCES %s(id)\n           ON DELETE CASCADE\n);".formatted(errorTableName, tableName));
        this.jdbcTemplate.execute("CREATE Index IF NOT EXISTS %s_created_at_idx ON %s (created_at);\n".formatted(errorTableName, errorTableName));
        log.info("Table created successfully for table {}", (Object)errorTableName);
    }
}

