/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.writer;

import com.pcistudio.task.procesor.StorageResolver;
import com.pcistudio.task.procesor.task.TaskInfo;
import com.pcistudio.task.procesor.task.TaskMetadata;
import com.pcistudio.task.procesor.writer.TaskInfoWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class H2TaskInfoWriter
implements TaskInfoWriter {
    private final JdbcTemplate jdbcTemplate;
    private final StorageResolver storageResolver;

    public TaskMetadata writeTasks(TaskInfo taskInfo) {
        String tableName = this.storageResolver.resolveStorageName(taskInfo.getHandlerName());
        this.jdbcTemplate.update("INSERT INTO %s (batch_id,status,version,created_at,updated_at,execution_time,payload,retry_count,handler_name,object_type)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)".formatted(tableName), new Object[]{taskInfo.getBatchId(), taskInfo.getStatus().name(), taskInfo.getVersion(), taskInfo.getCreatedAt(), taskInfo.getUpdatedAt(), taskInfo.getExecutionTime(), taskInfo.getPayloadBytes(), taskInfo.getRetryCount(), taskInfo.getHandlerName(), taskInfo.getObjectType()});
        Long id = (Long)this.jdbcTemplate.queryForObject("SELECT last_insert_id()", Long.class);
        taskInfo.setId(id);
        return taskInfo;
    }

    @Transactional
    public List<TaskMetadata> writeTasks(Collection<TaskInfo> taskInfoList) {
        return taskInfoList.stream().map(this::writeTasks).toList();
    }

    @Generated
    public H2TaskInfoWriter(JdbcTemplate jdbcTemplate, StorageResolver storageResolver) {
        this.jdbcTemplate = jdbcTemplate;
        this.storageResolver = storageResolver;
    }
}

