/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor;

import com.pcistudio.task.procesor.StorageResolver;
import com.pcistudio.task.procesor.TaskInfoErrorRepository;
import com.pcistudio.task.procesor.TaskInfoRepository;
import com.pcistudio.task.procesor.handler.TaskInfoService;
import com.pcistudio.task.procesor.page.Pageable;
import com.pcistudio.task.procesor.page.Sort;
import com.pcistudio.task.procesor.register.HandlerLookup;
import com.pcistudio.task.procesor.task.ProcessStatus;
import com.pcistudio.task.procesor.task.TaskInfo;
import com.pcistudio.task.procesor.task.TaskInfoError;
import com.pcistudio.task.procesor.task.TaskInfoOperations;
import com.pcistudio.task.procesor.util.Assert;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class JdbcTaskInfoService
implements TaskInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcTaskInfoService.class);
    private final StorageResolver storageResolver;
    private final HandlerLookup handlerLookup;
    private final TaskInfoRepository taskInfoRepository;
    private final TaskInfoErrorRepository taskInfoErrorRepository;

    public JdbcTaskInfoService(StorageResolver storageResolver, String partitionId, JdbcTemplate jdbcTemplate, Clock clock, HandlerLookup handlerLookup) {
        this.storageResolver = storageResolver;
        this.taskInfoRepository = new TaskInfoRepository(jdbcTemplate, clock, partitionId);
        this.taskInfoErrorRepository = new TaskInfoErrorRepository(jdbcTemplate, clock);
        this.handlerLookup = handlerLookup;
    }

    public List<TaskInfo> poll(String handlerName, int limit) {
        UUID readToken;
        String tableName = this.storageResolver.resolveStorageName(handlerName);
        int updated = this.taskInfoRepository.markToProcess(tableName, handlerName, readToken = UUID.randomUUID(), limit);
        if (updated == 0) {
            log.info("No tasks to process in tableName={}, handlerName={}", (Object)tableName, (Object)handlerName);
            return Collections.emptyList();
        }
        Duration processingExpire = this.handlerLookup.getProperties(handlerName).getProcessingExpire();
        List<TaskInfo> taskToProcess = this.taskInfoRepository.getTaskToProcess(tableName, handlerName, readToken, processingExpire);
        if (updated != taskToProcess.size()) {
            log.warn("Number of tasks={} to process is different from the number of tasks updated={} in tableName={}, handlerName={}", new Object[]{taskToProcess.size(), updated, tableName, handlerName});
        }
        if (taskToProcess.size() > limit) {
            log.warn("More tasks were returned than the limit={} in tableName={}, handlerName={}. System is failing to move task back to PENDING status", new Object[]{limit, tableName, handlerName});
        }
        return this.removeCorruptRecords(tableName, taskToProcess);
    }

    private List<TaskInfo> removeCorruptRecords(String tableName, List<TaskInfo> taskToProcess) {
        Iterator<TaskInfo> iterator = taskToProcess.iterator();
        while (iterator.hasNext()) {
            TaskInfo taskInfo = iterator.next();
            if (taskInfo.getStatus() != ProcessStatus.CORRUPT_RECORD) continue;
            iterator.remove();
            this.taskInfoRepository.markCorruptTask(tableName, (TaskInfoOperations)taskInfo);
        }
        return taskToProcess;
    }

    public void markTaskCompleted(TaskInfoOperations task) {
        String tableName = this.storageResolver.resolveStorageName(task.getHandlerName());
        if (task.getStatus() != ProcessStatus.PROCESSING) {
            log.warn("Task is not in PROCESSING status, task={}, handlerName={}, tableName={}. Can not mark COMPLETED. Current status={}", new Object[]{task.getId(), task.getHandlerName(), tableName, task.getStatus()});
            return;
        }
        this.taskInfoRepository.completeTask(tableName, task);
    }

    @Transactional
    public void markTaskToRetry(TaskInfoOperations task, Instant nextRetryTime) {
        String tableName = this.storageResolver.resolveStorageName(task.getHandlerName());
        if (task.getStatus() != ProcessStatus.PROCESSING) {
            log.warn("Task is not in PROCESSING status, task={}, handlerName={}, tableName={}. Can not mark PENDING. Current status={}", new Object[]{task.getId(), task.getHandlerName(), tableName, task.getStatus()});
            return;
        }
        this.taskInfoRepository.markToRetry(tableName, task, ProcessStatus.PROCESSING, ProcessStatus.PENDING, nextRetryTime);
        task.markForRetry();
        if (log.isInfoEnabled()) {
            log.info("Task={} mark for retry", (Object)task.getId());
        }
    }

    @Transactional
    public void markTaskFailed(TaskInfoOperations task) {
        String tableName = this.storageResolver.resolveStorageName(task.getHandlerName());
        if (task.getStatus() != ProcessStatus.PROCESSING) {
            log.warn("Task is not in PROCESSING status, task={}, handlerName={}, tableName={}. Can not mark FAILED. Current status={}", new Object[]{task.getId(), task.getHandlerName(), tableName, task.getStatus()});
            return;
        }
        this.taskInfoRepository.failTask(tableName, task);
        task.failed();
        if (log.isInfoEnabled()) {
            log.info("Task={} failed", (Object)task.getId());
        }
    }

    public Pageable<TaskInfo> getTasks(String handlerName, ProcessStatus processStatus, String pageToken, int limit, Sort sort) {
        String tableName = this.storageResolver.resolveStorageName(handlerName);
        return this.taskInfoRepository.getTasks(tableName, handlerName, processStatus, pageToken, limit, sort);
    }

    public Pageable<TaskInfo> getTasksRetried(String handlerName, String pageToken, int limit) {
        String tableName = this.storageResolver.resolveStorageName(handlerName);
        return this.taskInfoRepository.getTasksRetried(tableName, handlerName, pageToken, limit);
    }

    public List<TaskInfo> retrieveProcessingTimeoutTasks(String handlerName) {
        Duration processingExpire = this.handlerLookup.getProperties(handlerName).getProcessingExpire();
        Duration processingGracePeriod = this.handlerLookup.getProperties(handlerName).getProcessingGracePeriod();
        String tableName = this.storageResolver.resolveStorageName(handlerName);
        return this.taskInfoRepository.retrieveProcessingTimeoutTasks(tableName, handlerName, processingExpire.plus(processingGracePeriod));
    }

    public TaskInfoService.RequeueResult requeueTimeoutTask(String handlerName) {
        Duration processingExpire = this.handlerLookup.getProperties(handlerName).getProcessingExpire();
        Duration processingGracePeriod = this.handlerLookup.getProperties(handlerName).getProcessingGracePeriod();
        String tableName = this.storageResolver.resolveStorageName(handlerName);
        TaskInfoService.RequeueResult requeueResult = this.taskInfoRepository.requeueProcessingTimeoutTask(tableName, handlerName, processingExpire.plus(processingGracePeriod));
        if (!requeueResult.isEmpty()) {
            UUID batchId = requeueResult.batchId();
            Assert.notNull((Object)batchId, (String)"BatchId is null");
            List<TaskInfoError> timeoutTaskInfoError = this.taskInfoRepository.createBatchTaskInfoError(tableName, handlerName, batchId, "Processing timeout");
            if (log.isInfoEnabled()) {
                log.info("Timeout task found for handlerName={}, tableName={}, batchId={}, errors={}", new Object[]{handlerName, tableName, batchId, timeoutTaskInfoError.size()});
            }
            String errorTableName = this.storageResolver.resolveErrorStorageName(handlerName);
            this.taskInfoErrorRepository.saveErrors(errorTableName, timeoutTaskInfoError);
        }
        return requeueResult;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void storeError(TaskInfoError taskError) {
        if (taskError == TaskInfoError.EMPTY) {
            log.warn("Empty error received, nothing to store");
            return;
        }
        String handlerName = taskError.getHandlerName();
        Assert.notNull((Object)handlerName, (String)"Error without handlerName, nothing to store");
        String tableName = this.storageResolver.resolveErrorStorageName(handlerName);
        this.taskInfoErrorRepository.saveError(tableName, taskError);
        if (log.isInfoEnabled()) {
            log.info("Stored error processing task: {}", (Object)taskError);
        }
    }

    public List<TaskInfoError> getTaskErrors(String handlerName, Long taskId) {
        String tableName = this.storageResolver.resolveErrorStorageName(handlerName);
        List<TaskInfoError> taskErrors = this.taskInfoErrorRepository.getTaskErrors(tableName, taskId);
        if (log.isInfoEnabled()) {
            log.info("{} error found for task={}", (Object)taskErrors.size(), (Object)taskId);
        }
        return taskErrors;
    }

    public Map<String, Integer> stats(String handlerName, LocalDate date) {
        String tableName = this.storageResolver.resolveStorageName(handlerName);
        return this.taskInfoRepository.getStats(tableName, date);
    }

    public int count(String handlerName, LocalDate date) {
        String tableName = this.storageResolver.resolveStorageName(handlerName);
        return this.taskInfoRepository.getCount(tableName, date);
    }
}

