/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor;

import com.pcistudio.task.procesor.mapper.TaskInfoErrorMapper;
import com.pcistudio.task.procesor.task.TaskInfoError;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

class TaskInfoErrorRepository {
    private final JdbcTemplate jdbcTemplate;
    private final Clock clock;
    private final TaskInfoErrorMapper taskInfoErrorMapper = new TaskInfoErrorMapper();

    @Transactional
    public void saveError(String tableName, TaskInfoError taskInfoError) {
        Instant now = Instant.now(this.clock);
        this.jdbcTemplate.update("insert into %s (id, task_id, error_message, created_at,partition_id) %n values (?, ?, ?, ?, ?) ".formatted(tableName), new Object[]{taskInfoError.getId(), taskInfoError.getTaskId(), taskInfoError.getErrorMessage().substring(0, Math.min(taskInfoError.getErrorMessage().length(), 512)), now, taskInfoError.getPartitionId()});
    }

    public List<TaskInfoError> getTaskErrors(String tableName, Long taskId) {
        return this.jdbcTemplate.query("select id, task_id, error_message, created_at, partition_id %n from %s  %n where task_id = ? %n order by created_at desc%n".formatted(tableName), (RowMapper)this.taskInfoErrorMapper, new Object[]{taskId});
    }

    public void saveErrors(String tableName, List<TaskInfoError> timeoutTaskInfoError) {
        Instant now = Instant.now(this.clock);
        this.jdbcTemplate.batchUpdate("insert into %s (id, task_id, error_message, created_at, partition_id) %n values (?, ?, ?, ?, ?) %n".formatted(tableName), timeoutTaskInfoError, timeoutTaskInfoError.size(), (ps, taskInfoError) -> {
            ps.setObject(1, taskInfoError.getId());
            ps.setLong(2, taskInfoError.getTaskId());
            ps.setString(3, taskInfoError.getErrorMessage().substring(0, Math.min(taskInfoError.getErrorMessage().length(), 512)));
            ps.setObject(4, now);
            ps.setString(5, taskInfoError.getPartitionId());
        });
    }

    @Generated
    public TaskInfoErrorRepository(JdbcTemplate jdbcTemplate, Clock clock) {
        this.jdbcTemplate = jdbcTemplate;
        this.clock = clock;
    }
}

