/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor;

import com.pcistudio.task.procesor.TaskInfoCursorPageableFactory;
import com.pcistudio.task.procesor.handler.TaskInfoService;
import com.pcistudio.task.procesor.mapper.SimpleTaskInfoMapper;
import com.pcistudio.task.procesor.mapper.TaskInfoMapper;
import com.pcistudio.task.procesor.page.Cursor;
import com.pcistudio.task.procesor.page.Pageable;
import com.pcistudio.task.procesor.page.Sort;
import com.pcistudio.task.procesor.task.ProcessStatus;
import com.pcistudio.task.procesor.task.TaskInfo;
import com.pcistudio.task.procesor.task.TaskInfoError;
import com.pcistudio.task.procesor.task.TaskInfoOperations;
import com.pcistudio.task.procesor.util.Assert;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;

class TaskInfoRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInfoRepository.class);
    private final JdbcTemplate jdbcTemplate;
    private final Clock clock;
    private final String partitionId;
    private final SimpleTaskInfoMapper simpleMapper;
    private final TaskInfoCursorPageableFactory taskInfoCursorPageableFactory = new TaskInfoCursorPageableFactory();
    private final ProcessStatusCountRowMapper processStatusCountRowMapper;
    private final TaskInfoMapper taskInfoMapper = new TaskInfoMapper();

    public TaskInfoRepository(JdbcTemplate jdbcTemplate, Clock clock, String partitionId) {
        this.jdbcTemplate = jdbcTemplate;
        this.clock = clock;
        this.partitionId = partitionId;
        this.simpleMapper = new SimpleTaskInfoMapper(partitionId);
        this.processStatusCountRowMapper = new ProcessStatusCountRowMapper();
    }

    @Transactional
    public int markToProcess(String tableName, String handlerName, UUID readToken, int limit) {
        Instant now = Instant.now(this.clock);
        log.debug("Mark To process tableName={} handler={}, execution_time {} for partition_id {} with limit {}", new Object[]{tableName, handlerName, now, this.partitionId, limit});
        int updated = this.jdbcTemplate.update("update %s %nSET status=?, version=version + 1, updated_at=?, partition_id=?, read_token=? %nwhere execution_time<=? and status = ? and handler_name=? %norder by execution_time asc %nlimit ? %n".formatted(tableName), new Object[]{ProcessStatus.PROCESSING.name(), now, this.partitionId, readToken.toString(), now, ProcessStatus.PENDING.name(), handlerName, limit});
        log.debug("Mark to process {} tasks in tableName={}, handlerName={}", new Object[]{updated, tableName, handlerName});
        return updated;
    }

    @Transactional(readOnly=true)
    public List<TaskInfo> getTaskToProcess(String tableName, String handlerName, UUID readToken, Duration processingExpire) {
        List taskToProcess = this.jdbcTemplate.query("SELECT * FROM %s WHERE status = ? and  updated_at>? and execution_time<=? and handler_name=? and partition_id=? and read_token=? order by execution_time LIMIT 128".formatted(tableName), (RowMapper)this.simpleMapper, new Object[]{ProcessStatus.PROCESSING.name(), Instant.now(this.clock).minus(processingExpire), Instant.now(this.clock), handlerName, this.partitionId, readToken.toString()});
        if (log.isTraceEnabled()) {
            log.trace("Read {} records to process from tableName={}, handlerName={}", new Object[]{taskToProcess.size(), tableName, handlerName});
        }
        return taskToProcess;
    }

    public void completeTask(String tableName, TaskInfoOperations taskInfo) {
        Instant now = Instant.now(this.clock);
        int updated = this.jdbcTemplate.update("update %s SET status=?, version=version+1, updated_at=? where id=? and status=? and version=? and handler_name=?".formatted(tableName), new Object[]{ProcessStatus.COMPLETED.name(), now, taskInfo.getId(), ProcessStatus.PROCESSING.name(), taskInfo.getVersion(), taskInfo.getHandlerName()});
        if (updated == 0) {
            throw new OptimisticLockingFailureException("Task was not updated, task=" + taskInfo.getId() + " in table=" + tableName + " handlerName=" + taskInfo.getHandlerName());
        }
        if (log.isInfoEnabled()) {
            log.info("Task={} in tableName={},handlerName={} has completed", new Object[]{taskInfo.getId(), tableName, taskInfo.getHandlerName()});
        }
        taskInfo.completed();
    }

    public void markToRetry(String tableName, TaskInfoOperations task, ProcessStatus oldStatus, ProcessStatus newStatus, Instant nextRetryTime) {
        Instant now = Instant.now(this.clock);
        int updated = this.jdbcTemplate.update("update %s %n SET status=?, version=version+1, updated_at=?, retry_count=?, execution_time=?, partition_id=null %n where id=? and status = ? and version=? and handler_name=? ".formatted(tableName), new Object[]{newStatus.name(), now, task.getRetryCount() + 1, nextRetryTime, task.getId(), oldStatus.name(), task.getVersion(), task.getHandlerName()});
        if (updated == 0) {
            throw new OptimisticLockingFailureException("Task was not updated, task=%s from status=%s to status=%s".formatted(task.getId(), oldStatus, newStatus));
        }
        task.markForRetry();
    }

    public void failTask(String tableName, TaskInfoOperations task) {
        Instant now = Instant.now(this.clock);
        int updated = this.jdbcTemplate.update("update %s SET status=?, version=version+1, updated_at=? where id=? and status = ? and version=? and handler_name=?".formatted(tableName), new Object[]{ProcessStatus.FAILED.name(), now, task.getId(), ProcessStatus.PROCESSING.name(), task.getVersion(), task.getHandlerName()});
        if (updated == 0) {
            throw new OptimisticLockingFailureException("Task was not updated, task=%s from status=%s to status=%s".formatted(task.getId(), ProcessStatus.PROCESSING, ProcessStatus.FAILED));
        }
        task.failed();
    }

    public void markCorruptTask(String tableName, TaskInfoOperations task) {
        Instant now = Instant.now(this.clock);
        int updated = this.jdbcTemplate.update("update %s SET status=?, version=version+1, updated_at=? where id=? and version=? and handler_name=?".formatted(tableName), new Object[]{ProcessStatus.CORRUPT_RECORD.name(), now, task.getId(), task.getVersion(), task.getHandlerName()});
        if (updated == 0) {
            throw new OptimisticLockingFailureException("Task was not updated, task=" + task.getId() + " from status=" + task.getStatus().name() + " to status=" + String.valueOf(ProcessStatus.CORRUPT_RECORD));
        }
    }

    public Pageable<TaskInfo> getTasksRetried(String tableName, String handlerName, @Nullable String pageToken, int limit) {
        Cursor curs = this.taskInfoCursorPageableFactory.decodeCursor(pageToken);
        List retriedTasks = curs == null ? this.jdbcTemplate.query("SELECT * FROM %s WHERE retry_count>0 and handler_name=? limit ?".formatted(tableName), (RowMapper)this.taskInfoMapper, new Object[]{handlerName, limit}) : this.jdbcTemplate.query("SELECT * FROM %s WHERE retry_count>0 and handler_name=? and (execution_time>? or (execution_time=? and id>?)) order by execution_time asc, id asc limit ?".formatted(tableName), (RowMapper)this.taskInfoMapper, new Object[]{handlerName, curs.offset(), curs.offset(), curs.id(), limit});
        if (log.isTraceEnabled()) {
            log.trace("Read {} retried records tableName={}, handlerName={}", new Object[]{retriedTasks.size(), tableName, handlerName});
        }
        return this.taskInfoCursorPageableFactory.createPageable(retriedTasks, limit);
    }

    public Pageable<TaskInfo> getTasks(String tableName, String handlerName, ProcessStatus processStatus, String pageToken, int limit, Sort sort) {
        Cursor instantCursor = this.taskInfoCursorPageableFactory.decodeCursor(pageToken);
        List<TaskInfo> tasks = sort == Sort.ASC ? this.getOldestTasks(tableName, handlerName, processStatus, (Cursor<Instant>)instantCursor, limit) : this.getLatestTasks(tableName, handlerName, processStatus, (Cursor<Instant>)instantCursor, limit);
        return this.taskInfoCursorPageableFactory.createPageable(tasks, limit);
    }

    private List<TaskInfo> getLatestTasks(String tableName, String handlerName, ProcessStatus processStatus, @Nullable Cursor<Instant> pageToken, int limit) {
        if (pageToken == null) {
            return this.jdbcTemplate.query("SELECT * FROM %s where status=? and handler_name=? order by execution_time desc,id desc limit ?".formatted(tableName), (RowMapper)this.taskInfoMapper, new Object[]{processStatus.name(), handlerName, limit});
        }
        Instant executionTimeOffset = (Instant)pageToken.offset();
        return this.jdbcTemplate.query("SELECT * FROM %s where status=? and handler_name=? and (execution_time<? or (execution_time=? and id<?)) order by execution_time desc, id desc limit ?".formatted(tableName), (RowMapper)this.taskInfoMapper, new Object[]{processStatus.name(), handlerName, executionTimeOffset, executionTimeOffset, pageToken.id(), limit});
    }

    public List<TaskInfo> getOldestTasks(String tableName, String handlerName, ProcessStatus processStatus, @Nullable Cursor<Instant> pageToken, int limit) {
        if (pageToken == null) {
            return this.jdbcTemplate.query("SELECT * FROM %s where status=? and handler_name=? order by execution_time asc,id asc limit ?".formatted(tableName), (RowMapper)this.taskInfoMapper, new Object[]{processStatus.name(), handlerName, limit});
        }
        Instant executionTimeOffset = (Instant)pageToken.offset();
        return this.jdbcTemplate.query("SELECT * FROM %s where status=? and handler_name=? and (execution_time>? or (execution_time=? and id>?)) order by execution_time asc, id asc limit ?".formatted(tableName), (RowMapper)this.taskInfoMapper, new Object[]{processStatus.name(), handlerName, executionTimeOffset, executionTimeOffset, pageToken.id(), limit});
    }

    public TaskInfoService.RequeueResult requeueProcessingTimeoutTask(String tableName, String handlerName, Duration processingExpire) {
        Instant now = Instant.now(this.clock);
        UUID batchId = UUID.randomUUID();
        int updated = this.jdbcTemplate.update("update %s SET status=?, version=version+1, updated_at=?, batch_id=?, partition_id=null where status=? and updated_at<? and handler_name=?".formatted(tableName), new Object[]{ProcessStatus.PENDING.name(), now, batchId.toString(), ProcessStatus.PROCESSING.name(), now.minus(processingExpire), handlerName});
        if (updated == 0) {
            log.info("No timeout task found for handlerName={}, tableName={}", (Object)handlerName, (Object)tableName);
            return TaskInfoService.RequeueResult.EMPTY;
        }
        log.info("Requeue {} tasks in tableName={}, handlerName={}, batchId={}", new Object[]{updated, tableName, handlerName, batchId});
        return new TaskInfoService.RequeueResult(batchId, updated);
    }

    @Nullable
    public List<TaskInfo> retrieveRequeueForecast(String tableName, String handlerName, Duration processingExpire, Instant date) {
        return this.jdbcTemplate.query("select * from %s where status=? and updated_at<? and handler_name=? limit 100 sort by execution_time asc".formatted(tableName), (RowMapper)this.taskInfoMapper, new Object[]{ProcessStatus.PROCESSING.name(), date.minus(processingExpire), handlerName});
    }

    public List<TaskInfoError> createBatchTaskInfoError(String tableName, String handlerName, UUID batchId, String errorMessage) {
        Assert.notNull((Object)errorMessage, (String)"errorMessage must not be null");
        RowMapper rowMapper = (rs, rowNum) -> TaskInfoError.builder().handlerName(handlerName).taskId(Long.valueOf(rs.getLong("id"))).partitionId(rs.getString("partition_id")).errorMessage(errorMessage).createdAt(Instant.now(this.clock)).build();
        return this.jdbcTemplate.query("SELECT id,partition_id FROM %s where batch_id=?".formatted(tableName), rowMapper, new Object[]{batchId.toString()});
    }

    public List<TaskInfo> retrieveProcessingTimeoutTasks(String tableName, String handlerName, Duration processingExpire) {
        return this.jdbcTemplate.query("SELECT * FROM %s where status=? and updated_at<? and handler_name=?".formatted(tableName), (RowMapper)this.simpleMapper, new Object[]{ProcessStatus.PROCESSING.name(), Instant.now(this.clock).minus(processingExpire), handlerName});
    }

    public Map<String, Integer> getStats(String tableName, LocalDate date) {
        Instant startTime = date.atStartOfDay(this.clock.getZone()).toInstant();
        Instant endTime = date.plusDays(1L).atStartOfDay(this.clock.getZone()).toInstant();
        List processStatusCounts = this.jdbcTemplate.query("select status, count(*) as ct %nfrom %s %nwhere execution_time between ? and ? %ngroup by status %nunion all %nselect 'RETRY' as status, sum(retry_count) as ct %nfrom %s %nwhere execution_time between ? and ? %n".formatted(tableName, tableName), (RowMapper)this.processStatusCountRowMapper, new Object[]{startTime, endTime, startTime, endTime});
        return processStatusCounts.stream().collect(Collectors.toMap(ProcessStatusCount::status, ProcessStatusCount::count));
    }

    public Integer getCount(String tableName, LocalDate date) {
        Instant startTime = date.atStartOfDay(this.clock.getZone()).toInstant();
        Instant endTime = date.plusDays(1L).atStartOfDay(this.clock.getZone()).toInstant();
        Integer count = (Integer)this.jdbcTemplate.queryForObject("select count(*) as ct from %s where execution_time between ? and ?".formatted(tableName), Integer.class, new Object[]{startTime, endTime});
        return Objects.requireNonNullElse(count, 0);
    }

    private static final class ProcessStatusCountRowMapper
    implements RowMapper<ProcessStatusCount> {
        private ProcessStatusCountRowMapper() {
        }

        public ProcessStatusCount mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new ProcessStatusCount(rs.getString("status"), rs.getInt("ct"));
        }
    }

    record ProcessStatusCount(String status, int count) {
    }
}

