/*
 * Decompiled with CFR 0.152.
 */
package com.pcistudio.task.procesor.template;

import com.pcistudio.task.procesor.util.Assert;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class LoggingJdbcTemplate
extends JdbcTemplate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingJdbcTemplate.class);
    private final boolean showSql;

    public LoggingJdbcTemplate(DataSource dataSource, boolean showSql) {
        super(dataSource);
        this.showSql = showSql;
    }

    public LoggingJdbcTemplate(DataSource dataSource) {
        this(dataSource, false);
    }

    public int update(String sql, @Nullable PreparedStatementSetter pss) {
        int update = super.update(sql, pss);
        this.logSqlAndParameters(sql, pss);
        return update;
    }

    public <T> List<T> query(String sql, @Nullable PreparedStatementSetter pss, RowMapper<T> rowMapper) {
        List query = super.query(sql, pss, rowMapper);
        this.logSqlAndParameters(sql, pss);
        return query;
    }

    @Nullable
    public <T> T query(String sql, @Nullable PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws DataAccessException {
        Object query = super.query(sql, pss, rse);
        this.logSqlAndParameters(sql, pss);
        return (T)query;
    }

    private void logSqlAndParameters(String sql, @Nullable PreparedStatementSetter pss) {
        if (!log.isDebugEnabled()) {
            return;
        }
        if (this.showSql) {
            log.debug("SQL: " + sql);
        }
        if (pss instanceof ArgumentPreparedStatementSetter) {
            Field argsFields = ReflectionUtils.findField(ArgumentPreparedStatementSetter.class, (String)"args");
            if (argsFields == null) {
                log.debug("No parameters");
                return;
            }
            ReflectionUtils.makeAccessible((Field)argsFields);
            Object[] args = (Object[])ReflectionUtils.getField((Field)argsFields, (Object)pss);
            if (args == null) {
                log.debug("No parameters");
                return;
            }
            log.debug("Parameters: ");
            for (Object arg : args) {
                Assert.notNull((Object)arg, (String)"Argument must not be null");
                if (arg instanceof Instant) {
                    Instant instant = (Instant)arg;
                    log.debug("millis: {}<{}>", (Object)instant.toEpochMilli(), (Object)instant.atZone(ZoneId.systemDefault()).toLocalDateTime().toString());
                    continue;
                }
                if (arg instanceof byte[]) {
                    byte[] array = (byte[])arg;
                    log.debug("byte[{}]", (Object)array.length);
                    continue;
                }
                log.debug(arg.toString());
            }
        }
        log.debug("---------------------------------------------");
    }
}

