/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.preferences.encrypted;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import com.pddstudio.preferences.encrypted.R;
import com.scottyab.aescrypt.AESCrypt;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EncryptedPreferences {
    private static final String TAG = EncryptedPreferences.class.getSimpleName();
    private static EncryptedPreferences encryptedPreferences;
    private static EncryptedPreferences singletonInstance;
    private final SharedPreferences sharedPreferences;
    private final String cryptoKey;
    private final EncryptedEditor encryptedEditor;
    private final Utils utils;
    private final boolean printDebugMessages;
    private final List<OnSharedPreferenceChangeListenerImpl> listeners;

    @Deprecated
    public static EncryptedPreferences getInstance(Context context) {
        if (encryptedPreferences == null) {
            encryptedPreferences = new Builder(context).build();
        }
        return encryptedPreferences;
    }

    public static EncryptedPreferences getSingletonInstance() {
        if (singletonInstance == null) {
            throw new RuntimeException("Singleton instance doesn't exist. Did you forget to set Builder.withSaveAsSingleton(true) ?");
        }
        return singletonInstance;
    }

    private EncryptedPreferences(Builder builder) {
        SharedPreferences sharedPreferences = this.sharedPreferences = TextUtils.isEmpty((CharSequence)builder.prefsName) ? PreferenceManager.getDefaultSharedPreferences((Context)builder.context) : builder.context.getSharedPreferences(builder.prefsName, 0);
        if (TextUtils.isEmpty((CharSequence)builder.encryptionPassword)) {
            throw new RuntimeException("Unable to initialize EncryptedPreferences! Did you forget to set a password using Builder.withEncryptionPassword(encryptionKey) ?");
        }
        this.cryptoKey = builder.encryptionPassword;
        this.encryptedEditor = new EncryptedEditor(this);
        this.utils = new Utils(this);
        this.printDebugMessages = builder.context.getResources().getBoolean(R.bool.enable_debug_messages);
        this.listeners = new ArrayList<OnSharedPreferenceChangeListenerImpl>();
        if (!builder.listeners.isEmpty()) {
            for (OnSharedPreferenceChangeListener listener : builder.listeners) {
                this.registerListener(listener);
            }
        }
        singletonInstance = builder.singleton ? this : null;
    }

    private synchronized void log(String logMessage) {
        if (this.printDebugMessages) {
            Log.d((String)TAG, (String)logMessage);
        }
    }

    private void registerListener(OnSharedPreferenceChangeListener listener) {
        if (this.checkIfListenerExist(listener)) {
            this.log("registerListener() : " + listener + " is already registered - skip adding.");
        } else {
            OnSharedPreferenceChangeListenerImpl listenerImpl = new OnSharedPreferenceChangeListenerImpl(this, listener);
            this.sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)listenerImpl);
            this.listeners.add(listenerImpl);
            this.log("registerListener() : interface registered: " + listener + " ");
        }
    }

    private void unregisterListener(OnSharedPreferenceChangeListener listener) {
        if (this.checkIfListenerExist(listener)) {
            OnSharedPreferenceChangeListenerImpl listenerImpl = this.getListenerImpl(listener);
            this.sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)listenerImpl);
            this.removeListenerImpl(listener);
            this.log("unregisterListener() : " + listenerImpl + " ( interface: " + listener + " )");
        } else {
            this.log("unregisterListener() : unable to find registered listener ( " + listener + ")");
        }
    }

    private OnSharedPreferenceChangeListenerImpl getListenerImpl(OnSharedPreferenceChangeListener listener) {
        for (OnSharedPreferenceChangeListenerImpl listenerImpl : this.listeners) {
            if (!listener.equals(listenerImpl.getListenerInterface())) continue;
            return listenerImpl;
        }
        return null;
    }

    private boolean checkIfListenerExist(OnSharedPreferenceChangeListener changeListener) {
        for (OnSharedPreferenceChangeListenerImpl listenerImpl : this.listeners) {
            if (!changeListener.equals(listenerImpl.getListenerInterface())) continue;
            this.log("checkListener() : " + changeListener + " found implementation: " + listenerImpl);
            return true;
        }
        return false;
    }

    private void removeListenerImpl(OnSharedPreferenceChangeListener listener) {
        this.log("removeListenerImpl() : requested for " + listener);
        for (int i = 0; i < this.listeners.size(); ++i) {
            OnSharedPreferenceChangeListenerImpl listenerImpl = this.listeners.get(i);
            if (!listener.equals(listenerImpl.getListenerInterface())) continue;
            this.listeners.remove(i);
            this.log("removeListenerImpl() : removed listener at position: " + i);
        }
    }

    private void printListeners() {
        if (this.listeners.isEmpty()) {
            this.log("printListeners() => no listeners found");
        } else {
            for (OnSharedPreferenceChangeListenerImpl listenerImpl : this.listeners) {
                this.log("printListeners() => " + listenerImpl);
            }
        }
    }

    private void removeExistingPreferenceKey(String preferenceKey) {
        this.removeExistingPreferenceKeys(preferenceKey);
    }

    private void removeExistingPreferenceKeys(String ... preferenceKeys) {
        HashSet<String> targetEntries = new HashSet<String>();
        for (String key : preferenceKeys) {
            if (this.sharedPreferences.contains(key)) {
                targetEntries.add(key);
                continue;
            }
            this.log("removeExistingPreferenceKey() : Couldn't find key '" + key + "' ! Skipping...");
        }
        SharedPreferences.Editor batchEditor = this.sharedPreferences.edit();
        for (String targetKey : targetEntries) {
            batchEditor.remove(targetKey);
        }
        batchEditor.apply();
    }

    private String encryptString(String message) {
        try {
            String encString = AESCrypt.encrypt((String)this.cryptoKey, (String)message);
            return this.encodeCharset(encString);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String decryptString(String message) {
        try {
            String decString = this.removeEncoding(message);
            return AESCrypt.decrypt((String)this.cryptoKey, (String)decString);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    private String removeEncoding(String value) {
        String encodedString = value;
        encodedString = encodedString.replaceAll("x0P1Xx", "\\+").replaceAll("x0P2Xx", "/").replaceAll("x0P3Xx", "=");
        this.log("removeEncoding() : " + value + " => " + encodedString);
        return encodedString;
    }

    private String encodeCharset(String value) {
        String encodedString = value;
        encodedString = encodedString.replaceAll("\\+", "x0P1Xx").replaceAll("/", "x0P2Xx").replaceAll("=", "x0P3Xx");
        this.log("encodeCharset() : " + value + " => " + encodedString);
        return encodedString;
    }

    private boolean containsEncryptedKey(String encryptedKey) {
        return this.sharedPreferences.contains(encryptedKey);
    }

    private <T> Object decryptType(String key, Object type, T defaultType) {
        String encKey = this.encryptString(key);
        this.log("decryptType() => encryptedKey => " + encKey);
        if (TextUtils.isEmpty((CharSequence)encKey) || !this.containsEncryptedKey(encKey)) {
            this.log("unable to encrypt or find key => " + encKey);
            return defaultType;
        }
        String value = this.sharedPreferences.getString(encKey, null);
        this.log("decryptType() => encryptedValue => " + value);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return defaultType;
        }
        String orgValue = this.decryptString(value);
        this.log("decryptType() => orgValue => " + orgValue);
        if (TextUtils.isEmpty((CharSequence)orgValue)) {
            return defaultType;
        }
        if (type instanceof String) {
            return orgValue;
        }
        if (type instanceof Integer) {
            try {
                return Integer.parseInt(orgValue);
            }
            catch (NumberFormatException e) {
                return defaultType;
            }
        }
        if (type instanceof Long) {
            try {
                return Long.parseLong(orgValue);
            }
            catch (NumberFormatException e) {
                return defaultType;
            }
        }
        if (type instanceof Float) {
            try {
                return Float.valueOf(Float.parseFloat(orgValue));
            }
            catch (NumberFormatException e) {
                return defaultType;
            }
        }
        if (type instanceof Boolean) {
            return Boolean.parseBoolean(orgValue);
        }
        return defaultType;
    }

    public int getInt(String key, int defaultValue) {
        return (Integer)this.decryptType(key, 0, defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return (Long)this.decryptType(key, 0L, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return (Boolean)this.decryptType(key, defaultValue, defaultValue);
    }

    public float getFloat(String key, float defaultValue) {
        return ((Float)this.decryptType(key, Float.valueOf(0.0f), Float.valueOf(defaultValue))).floatValue();
    }

    public String getString(String key, String defaultValue) {
        return (String)this.decryptType(key, "", defaultValue);
    }

    public Set<String> getAllKeys(boolean decrypt) {
        if (decrypt) {
            HashSet<String> decryptedKeySet = new HashSet<String>();
            for (String key : this.sharedPreferences.getAll().keySet()) {
                decryptedKeySet.add(this.decryptString(key));
            }
            return decryptedKeySet;
        }
        return this.sharedPreferences.getAll().keySet();
    }

    public Set<String> getAllKeys() {
        return this.getAllKeys(true);
    }

    public boolean contains(String key) {
        String encKey = this.encryptString(key);
        return this.sharedPreferences.contains(encKey);
    }

    public EncryptedEditor edit() {
        return this.encryptedEditor;
    }

    public Utils getUtils() {
        return this.utils;
    }

    public void importSharedPreferences(SharedPreferences sharedPreferences, boolean override) {
        this.importSharedPreferences(sharedPreferences, override, false);
    }

    public void importSharedPreferences(SharedPreferences sharedPreferences, boolean override, boolean removeAfter) {
        if (sharedPreferences != null) {
            Map values = sharedPreferences.getAll();
            int importCount = 0;
            for (String key : values.keySet()) {
                if (!this.contains(key) || this.contains(key) && override) {
                    this.log("-> Importing key: " + key);
                    this.encryptedEditor.putValue(key, String.valueOf(values.get(key)));
                    this.encryptedEditor.apply();
                    ++importCount;
                    if (!removeAfter || !this.contains(key)) continue;
                    sharedPreferences.edit().remove(key).apply();
                    this.log("-> Deleted entry for key : " + key);
                    continue;
                }
                this.log("-> Skip import for " + key + " : key already exist");
            }
            this.log("Import finished! (" + importCount + "/" + values.size() + " entries imported)");
        }
    }

    public void forceDeleteExistingPreferences() {
        Set storedKeys = this.sharedPreferences.getAll().keySet();
        this.removeExistingPreferenceKeys(storedKeys.toArray(new String[storedKeys.size()]));
    }

    public void registerOnSharedPreferenceChangeListener(OnSharedPreferenceChangeListener listener) {
        if (listener != null) {
            this.registerListener(listener);
        }
    }

    public void unregisterOnSharedPreferenceChangeListener(OnSharedPreferenceChangeListener listener) {
        if (listener != null) {
            this.unregisterListener(listener);
        }
    }

    public static final class Builder {
        private final Context context;
        private String encryptionPassword;
        private String prefsName;
        private boolean singleton = false;
        private final List<OnSharedPreferenceChangeListener> listeners;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
            this.listeners = new ArrayList<OnSharedPreferenceChangeListener>();
        }

        public Builder withEncryptionPassword(String encryptionPassword) {
            this.encryptionPassword = encryptionPassword;
            return this;
        }

        public Builder withPreferenceName(String preferenceName) {
            this.prefsName = preferenceName;
            return this;
        }

        public Builder withSaveAsSingleton(boolean singleton) {
            this.singleton = singleton;
            return this;
        }

        public Builder withOnSharedPreferenceChangeListener(OnSharedPreferenceChangeListener listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
            return this;
        }

        public EncryptedPreferences build() {
            return new EncryptedPreferences(this);
        }
    }

    public final class EncryptedEditor {
        private final String TAG = EncryptedEditor.class.getSimpleName();
        private final EncryptedPreferences encryptedPreferences;
        private final SharedPreferences.Editor editor;

        private EncryptedEditor(EncryptedPreferences encryptedPreferences) {
            this.encryptedPreferences = encryptedPreferences;
            this.editor = encryptedPreferences.sharedPreferences.edit();
        }

        private synchronized void log(String logMessage) {
            if (this.encryptedPreferences.printDebugMessages) {
                Log.d((String)this.TAG, (String)logMessage);
            }
        }

        private SharedPreferences.Editor editor() {
            return this.editor;
        }

        private String encryptValue(String value) {
            String encryptedString = this.encryptedPreferences.encryptString(value);
            this.log("encryptValue() => " + encryptedString);
            return encryptedString;
        }

        private void putValue(String key, String value) {
            this.log("putValue() => " + key + " [" + this.encryptValue(key) + "] || " + value + " [" + this.encryptValue(value) + "]");
            this.editor().putString(this.encryptValue(key), this.encryptValue(value));
        }

        public EncryptedEditor putString(String key, String value) {
            this.putValue(key, value);
            return this;
        }

        public EncryptedEditor putInt(String key, int value) {
            this.putValue(key, String.valueOf(value));
            return this;
        }

        public EncryptedEditor putLong(String key, long value) {
            this.putValue(key, String.valueOf(value));
            return this;
        }

        public EncryptedEditor putFloat(String key, float value) {
            this.putValue(key, String.valueOf(value));
            return this;
        }

        public EncryptedEditor putBoolean(String key, boolean value) {
            this.putValue(key, String.valueOf(value));
            return this;
        }

        public EncryptedEditor remove(String key) {
            String encKey = this.encryptValue(key);
            if (EncryptedPreferences.this.containsEncryptedKey(encKey)) {
                this.log("remove() => " + key + " [ " + encKey + " ]");
                this.editor().remove(encKey);
            }
            return this;
        }

        public EncryptedEditor clear() {
            this.log("clear() => clearing preferences.");
            this.editor().clear();
            return this;
        }

        public void apply() {
            this.editor().apply();
        }

        public boolean commit() {
            return this.editor().commit();
        }
    }

    private class OnSharedPreferenceChangeListenerImpl
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private final OnSharedPreferenceChangeListener listener;
        private final EncryptedPreferences encryptedPreferences;

        private OnSharedPreferenceChangeListenerImpl(EncryptedPreferences encryptedPreferences2, OnSharedPreferenceChangeListener listener) {
            this.listener = listener;
            this.encryptedPreferences = encryptedPreferences2;
        }

        protected OnSharedPreferenceChangeListener getListenerInterface() {
            return this.listener;
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            if (EncryptedPreferences.this.checkIfListenerExist(this.listener)) {
                EncryptedPreferences.this.log("onSharedPreferenceChanged() : found listener " + this.listener);
                this.listener.onSharedPreferenceChanged(this.encryptedPreferences, this.encryptedPreferences.getUtils().decryptStringValue(key));
            } else {
                EncryptedPreferences.this.log("onSharedPreferenceChanged() : couldn't find listener (" + this.listener + ")");
            }
        }
    }

    public final class Utils {
        private final EncryptedPreferences encryptedPreferences;

        private Utils(EncryptedPreferences encryptedPreferences) {
            this.encryptedPreferences = encryptedPreferences;
        }

        public String encryptStringValue(String value) {
            return this.encryptedPreferences.encryptString(value);
        }

        public String decryptStringValue(String value) {
            return this.encryptedPreferences.decryptString(value);
        }
    }

    public static interface OnSharedPreferenceChangeListener {
        public void onSharedPreferenceChanged(EncryptedPreferences var1, String var2);
    }
}

