package com.pddstudio.linodeapi;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import com.pddstudio.linodeapi.utils.MD5Utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

/*
 * This Class was created by Patrick J
 * on 12.05.16. For more Details and Licensing
 * have a look at the README.md
 */

/**
 * Class to represent a logged in User
 */
public class LinodeUser {

    private String username;
    private String password;
    private String token;

    public LinodeUser() {}

    public LinodeUser(String username, String password, String token) {
        this.username = username;
        this.password = password;
        this.token = token;
    }

    /**
     * Returns the username of this user
     * @return
     */
    public String getUsername() {
        return username;
    }

    /**
     * Sets the username for this user
     * @param username
     */
    public void setUsername(String username) {
        this.username = username;
    }

    /**
     * Returns the password of this user
     * @return
     */
    public String getPassword() {
        return password;
    }

    /**
     * Sets the password for this user
     * @param password
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * Returns the token of this user
     * @return
     */
    public String getToken() {
        return token;
    }

    /**
     * Sets the token for this user
     * @param token
     */
    public void setToken(String token) {
        this.token = token;
    }

    /**
     * Returns the url for the user's profile image as String
     * @return
     */
    public String getProfileImageUrl() {
        String hexAcc = MD5Utils.md5Hex(username);
        return "http://www.gravatar.com/avatar/" + hexAcc + ".jpg";
    }

    /**
     * Returns the url for the user's profile image in a specific size as String.
     * @param profileImageSizePx - Size of the profile image in px
     * @return
     */
    public String getProfileImageUrl(int profileImageSizePx) {
        String hexAcc = MD5Utils.md5Hex(username);
        return "http://www.gravatar.com/avatar/" + hexAcc + ".jpg?s=" + profileImageSizePx;
    }

    /**
     * Returns the user's profile image as {@linkplain android.graphics.Bitmap}.
     * <p>This is a synchronous request and must not be executed on the UI-Thread.</p>
     * @return
     */
    public Bitmap getProfileImage() {
        try {
            URL url = new URL(getProfileImageUrl());
            final URLConnection conn = url.openConnection();
            conn.connect();
            final BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
            final Bitmap bm = BitmapFactory.decodeStream(bis);
            bis.close();
            return bm;
        } catch (IOException e) {}
        return null;
    }

    /**
     * Returns the user's profile image in a specified size as {@linkplain android.graphics.Bitmap}.
     * <p>This is a synchronous request and must not be executed on the UI-Thread.</p>
     * @param profileImageSizePx
     * @return
     */
    public Bitmap getProfileImage(int profileImageSizePx) {
        try {
            URL url = new URL(getProfileImageUrl(profileImageSizePx));
            final URLConnection conn = url.openConnection();
            conn.connect();
            final BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
            final Bitmap bm = BitmapFactory.decodeStream(bis);
            bis.close();
            return bm;
        } catch (IOException e) {}
        return null;
    }


}
