/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.abstracts;
/*
 * This Class was created by Patrick J
 * on 27.02.16. For more Details and licensing information
 * have a look at the README.md
 */

public abstract class ApiError {

    public ApiError() {}

    //should return the type of the API Error
    public abstract String getErrorType();

    //should return the error code of the API Error (if none is found, -1 will be used)
    public abstract int getErrorCode();

    //should return the description of the API Error (if available, otherwise null or an empty string)
    public abstract String getErrorDescription();

}
