/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.abstracts;
/*
 * This Class was created by Patrick J
 * on 28.02.16. For more Details and licensing information
 * have a look at the README.md
 */

import com.google.gson.annotations.SerializedName;
import com.pddstudio.linodeapi.models.data.ErrorCodeData;

public abstract class BaseModel<T> {

    @SerializedName("ERRORARRAY") private ErrorCodeData[] errorArray;
    @SerializedName("ACTION") private String calledAction;
    @SerializedName("DATA") protected T responseData;

    private final transient Class<?> modelClass;

    public BaseModel(Class<?> modelClassType) {
        this.modelClass = modelClassType;
    }


    public ErrorCodeData[] getErrorCodeArray() {
        return errorArray;
    }

    public String getCalledAction() {
        return calledAction;
    }

    public T getResponseData() {
        return responseData;
    }

    public Class<?> getModelClass() {
        return modelClass;
    }

}
