/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.actions;
/*
 * This Class was created by Patrick J
 * on 27.02.16. For more Details and licensing information
 * have a look at the README.md
 */

import com.pddstudio.linodeapi.abstracts.BaseModel;
import com.pddstudio.linodeapi.interfaces.ApiAction;
import com.pddstudio.linodeapi.models.AccountEstimateInvoice;
import com.pddstudio.linodeapi.models.AccountInfo;

/**
 * API methods for interacting with your Linode Manager account.
 * @see <a href="https://www.linode.com/api/account">https://www.linode.com/api/account</a>
 */
public enum Account implements ApiAction {

    /**
     * Estimates the invoice for adding a new Linode or NodeBalancer as well as resizing a Linode. This returns two fields: PRICE which is the estimated cost of the invoice, and INVOICE_TO which is the date invoice would be though with timezone set to America/New_York
     * @see <a href="https://www.linode.com/api/account/account.estimateinvoice">https://www.linode.com/api/account/account.estimateinvoice</a>
     */
    ESTIMATE_INVOICE("account.estimateinvoice", new AccountEstimateInvoice()),

    /**
     * Shows information about your account such as the date your account was opened as well as your network utilization for the current month in gigabytes.
     * @see <a href="https://www.linode.com/api/account/account.info">https://www.linode.com/api/account/account.info</a>
     */
    INFO("account.info", new AccountInfo());

    private final String apiCommand;
    private final BaseModel baseModelType;

    Account(String apiCommand, BaseModel baseModelType) {
        this.apiCommand = apiCommand;
        this.baseModelType = baseModelType;
    }

    public String getApiCommand() {
        return apiCommand;
    }

    public BaseModel getBaseModel() {
        return baseModelType;
    }

}
