/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.actions;
/*
 * This Class was created by Patrick J
 * on 29.02.16. For more Details and licensing information
 * have a look at the README.md
 */

import com.pddstudio.linodeapi.abstracts.BaseModel;
import com.pddstudio.linodeapi.interfaces.ApiAction;
import com.pddstudio.linodeapi.models.NodeBalancerInfo;
import com.pddstudio.linodeapi.models.NodeBalancerListInfo;

/**
 * Create and manage NodeBalancers, the managed load balancing service (lbass) from Linode, using this family of API calls.
 * @see <a href="https://www.linode.com/api/nodebalancer">https://www.linode.com/api/nodebalancer</a>
 */
public enum NodeBalancer implements ApiAction {

    /**
     * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.create">https://www.linode.com/api/nodebalancer/nodebalancer.create</a>
     */
    CREATE("nodebalancer.create", new NodeBalancerListInfo()),

    /**
     * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.delete">https://www.linode.com/api/nodebalancer/nodebalancer.delete</a>
     */
    DELETE("nodebalancer.delete", new NodeBalancerListInfo()),

    /**
     * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.list">https://www.linode.com/api/nodebalancer/nodebalancer.list</a>
     */
    LIST("nodebalancer.list", new NodeBalancerListInfo()),

    /**
     * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.update">https://www.linode.com/api/nodebalancer/nodebalancer.update</a>
     */
    UPDATE("nodebalancer.update", new NodeBalancerListInfo());

    private final String apiCommand;
    private final BaseModel baseModelType;

    NodeBalancer(String apiCommand, BaseModel baseModelType) {
        this.apiCommand = apiCommand;
        this.baseModelType = baseModelType;
    }

    @Override
    public String getApiCommand() {
        return apiCommand;
    }

    @Override
    public BaseModel getBaseModel() {
        return baseModelType;
    }


    public enum Config implements ApiAction {

        /**
         * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.config.create">https://www.linode.com/api/nodebalancer/nodebalancer.config.create</a>
         */
        CREATE("nodebalancer.config.create", new NodeBalancerInfo()),

        /**
         * Deletes a NodeBalancer's Config
         * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.config.delete">https://www.linode.com/api/nodebalancer/nodebalancer.config.delete</a>
         */
        DELETE("nodebalancer.config.delete", new NodeBalancerInfo()),

        /**
         * Returns a list of NodeBalancers this user has access or delete to, including their properties
         * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.config.list">https://www.linode.com/api/nodebalancer/nodebalancer.config.list</a>
         */
        LIST("nodebalancer.config.list", new NodeBalancerListInfo()),

        /**
         * Updates a Config's properties
         * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.config.update">https://www.linode.com/api/nodebalancer/nodebalancer.config.update</a>
         */
        UPDATE("nodebalancer.config.update", new NodeBalancerInfo());

        private final String apiCommand;
        private final BaseModel baseModelType;

        Config(String apiCommand, BaseModel baseModelType) {
            this.apiCommand = apiCommand;
            this.baseModelType = baseModelType;
        }

        @Override
        public String getApiCommand() {
            return apiCommand;
        }

        @Override
        public BaseModel getBaseModel() {
            return baseModelType;
        }

    }

    public enum Node implements ApiAction {

        /**
         * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.node.create">https://www.linode.com/api/nodebalancer/nodebalancer.node.create</a>
         */
        CREATE("nodebalancer.node.create", new NodeBalancerInfo()),

        /**
         * Deletes a Node from a NodeBalancer Config
         * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.node.delete">https://www.linode.com/api/nodebalancer/nodebalancer.node.delete</a>
         */
        DELETE("nodebalancer.node.delete", new NodeBalancerInfo()),

        /**
         * Returns a list of Nodes associated with a NodeBalancer Config
         * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.node.list">https://www.linode.com/api/nodebalancer/nodebalancer.node.list</a>
         */
        LIST("nodebalancer.node.list", new NodeBalancerListInfo()),

        /**
         * Updates a Node's properties
         * @see <a href="https://www.linode.com/api/nodebalancer/nodebalancer.node.update">https://www.linode.com/api/nodebalancer/nodebalancer.node.update</a>
         */
        UPDATE("nodebalancer.node.update", new NodeBalancerInfo());

        private final String apiCommand;
        private final BaseModel baseModelType;

        Node(String apiCommand, BaseModel baseModelType) {
            this.apiCommand = apiCommand;
            this.baseModelType = baseModelType;
        }

        @Override
        public String getApiCommand() {
            return apiCommand;
        }

        @Override
        public BaseModel getBaseModel() {
            return baseModelType;
        }

    }

}
