/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.actions;
/*
 * This Class was created by Patrick J
 * on 27.02.16. For more Details and licensing information
 * have a look at the README.md
 */

import com.pddstudio.linodeapi.abstracts.BaseModel;
import com.pddstudio.linodeapi.interfaces.ApiAction;
import com.pddstudio.linodeapi.models.UserInfo;

public enum User implements ApiAction {

    /**
     * Authenticates a Linode Manager user against their username, password, and two-factor token (when enabled), and then returns a new API key, which can be used until it expires.
     * @see <a href="https://www.linode.com/api/account/user.getapikey">https://www.linode.com/api/account/user.getapikey</a>
     */
    GET_API_KEY("user.getapikey", new UserInfo());

    private final String apiCommand;
    private final BaseModel baseModelType;

    User(String apiCommand, BaseModel baseModelType) {
        this.apiCommand = apiCommand;
        this.baseModelType = baseModelType;
    }

    @Override
    public String getApiCommand() {
        return apiCommand;
    }

    @Override
    public BaseModel getBaseModel() {
        return baseModelType;
    }

}
