/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.async;
/*
 * This Class was created by Patrick J
 * on 29.02.16. For more Details and licensing information
 * have a look at the README.md
 */

import android.os.AsyncTask;

import com.google.gson.Gson;
import com.pddstudio.linodeapi.LinodeApi;
import com.pddstudio.linodeapi.LinodeLogin;
import com.pddstudio.linodeapi.LinodeUser;
import com.pddstudio.linodeapi.config.LinodePreferences;
import com.pddstudio.linodeapi.models.UserInfo;
import com.pddstudio.linodeapi.utils.Logger;

import java.io.IOException;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class AsyncLoginTask extends AsyncTask<Void, Void, UserInfo> {

    private final String requestUrl;
    private final LinodeLogin linodeLogin;
    private final LinodePreferences linodePreferences;
    private final String username;
    private final String password;
    private final String token;

    public AsyncLoginTask(LinodeLogin linodeLogin) {
        this.requestUrl = "https://api.linode.com/?api_action=user.getapikey&username=" + linodeLogin.getUsername() + "&password=" + linodeLogin.getPassword() + (linodeLogin.withToken() ? "&token=" + linodeLogin.getToken() : "") + "&expires=0&label=LINODE_ANDROID_API_KEY";
        this.linodeLogin = linodeLogin;
        this.linodePreferences = LinodePreferences.getInstance(LinodeApi.getInstance().getContext());
        this.username = linodeLogin.getUsername();
        this.password = linodeLogin.getPassword();
        this.token = linodeLogin.getToken();
    }

    @Override
    protected UserInfo doInBackground(Void... params) {
        Gson gson = new Gson();
        OkHttpClient okHttpClient = new OkHttpClient();

        Logger.log(this, "Building and executing request for given URL: " + requestUrl);

        try {

            Request request = new Request.Builder().url(requestUrl).build();
            Response response = okHttpClient.newCall(request).execute();
            if(!response.isSuccessful()) this.cancel(true);
            UserInfo userInfo = gson.fromJson(response.body().charStream(), UserInfo.class);
            if(userInfo != null) return userInfo;

        } catch (IOException io) {
            Logger.log(this, "API call execution failed! Reason:\n" + io.getMessage());
            this.cancel(true);
        }

        return null;
    }

    @Override
    public void onPostExecute(UserInfo userInfo) {
        if(userInfo != null) {
            if(userInfo.getErrorCodeArray().length > 0) linodeLogin.getCallback().onLoginFailed(userInfo.getErrorCodeArray());
            else {
                String apiKey = userInfo.getResponseData().getApiKey();
                Logger.log(this, "API-Key received successfully [" + apiKey + "]");
                linodePreferences.setCurrentApiKey(apiKey);
                linodePreferences.setCurrentUsername(username);
                linodePreferences.setCurrentPassword(password);
                linodeLogin.getCallback().onLoginSuccess(new LinodeUser(username, password, apiKey));
            }
        }
    }

}
