/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.config;
/*
 * This Class was created by Patrick J
 * on 27.02.16. For more Details and licensing information
 * have a look at the README.md
 */

import android.content.Context;
import android.content.SharedPreferences;

import com.pddstudio.linodeapi.utils.Logger;

public final class LinodePreferences {

    //static name for the preference file
    private static final String PREFERENCES_NAME = "LinodePreferences";

    //preference keys for various information saved by the api
    private static final String CURRENT_API_KEY = "currentApiKey";
    private static final String CURRENT_USERNAME = "currentUserName";
    private static final String CURRENT_PASSWORD = "currentUserPwd";
    private static final String CURRENT_TOKEN = "currentUserToken";
    private static final String USE_TOKEN_AUTH = "tokenAuthEnabled";

    private static LinodePreferences linodePreferences;

    private final Context context;
    private final SharedPreferences sharedPreferences;

    private LinodePreferences(Context context) {
        this.context = context;
        this.sharedPreferences = context.getSharedPreferences(buildPreferenceName(), Context.MODE_PRIVATE);
        Logger.log(this, "LinodePreferences instance created.");
    }

    public static LinodePreferences getInstance(Context context) {
        if(linodePreferences == null) linodePreferences = new LinodePreferences(context);
        return linodePreferences;
    }

    private String buildPreferenceName() {
        String prefName = context.getPackageName() + "." + PREFERENCES_NAME;
        Logger.log(this, "buildPreferenceName() returned -> " + prefName);
        return prefName;
    }

    /*
    GETTER AND SETTER METHODS FOR REQUIRED INFORMATION
     */

    public void setCurrentApiKey(String apiKey) {
        if(apiKey != null && !apiKey.isEmpty()) sharedPreferences.edit().putString(CURRENT_API_KEY, apiKey).apply();
        else Logger.log(this, "Warning: Can't update current api key, the given value must not be null or empty!");
    }

    public String getCurrentApiKey() {
        return sharedPreferences.getString(CURRENT_API_KEY, null);
    }

    public boolean isApiKeyAvailable() {
        String key = sharedPreferences.getString(CURRENT_API_KEY, null);
        return key != null && !key.isEmpty();
    }

    public void setCurrentUsername(String username) {
        if(username != null && !username.isEmpty()) sharedPreferences.edit().putString(CURRENT_USERNAME, username).apply();
        else Logger.log(this, "Warning: Can't update username, the given value must not be null or empty!");
    }

    public String getCurrentUsername() {
        return sharedPreferences.getString(CURRENT_USERNAME, null);
    }

    public boolean isUsernameAvailable() {
        String key = sharedPreferences.getString(CURRENT_USERNAME, null);
        return key != null && !key.isEmpty();
    }

    public void setCurrentPassword(String password) {
        if(password != null && !password.isEmpty()) sharedPreferences.edit().putString(CURRENT_PASSWORD, password).apply();
        else Logger.log(this, "Warning: Can't update password, the given value must not be null or empty!");
    }

    public String getCurrentPassword() {
        return sharedPreferences.getString(CURRENT_PASSWORD, null);
    }

    public boolean isPasswordAvailable() {
        String key = sharedPreferences.getString(CURRENT_PASSWORD, null);
        return key != null && !key.isEmpty();
    }

}
