/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.enums;
/*
 * This Class was created by Patrick J
 * on 01.03.16. For more Details and licensing information
 * have a look at the README.md
 */

import com.pddstudio.linodeapi.models.data.ErrorCodeData;

public enum ValidationType {
    SUCCESS,
    SKIPPED,
    MISSING_CREDENTIALS,
    MISSING_TOKEN,
    UNKNOWN_ERROR;

    ValidationType() {}

    public static ValidationType forErrorCode(ErrorCodeData errorCodeData) {
        if(errorCodeData.getErrorCode() == 4) return MISSING_CREDENTIALS;
        if(errorCodeData.getErrorCode() == 44) return MISSING_TOKEN;
        return UNKNOWN_ERROR;
    }
}
