/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.interfaces;
/*
 * This Class was created by Patrick J
 * on 28.02.16. For more Details and licensing information
 * have a look at the README.md
 */

import com.pddstudio.linodeapi.LinodeResponse;
import com.pddstudio.linodeapi.models.data.ErrorCodeData;

/**
 * Interface used for all kind of requests on the Linode API.
 * <p>All callbacks will be delivered asynchronous.
 * You may use one callback interface for all kind of requests - as because those are generic.</p>
 */
public interface LinodeRequestCallback {
    /**
     * Gets invoked once an API request started.
     */
    void onRequestStarted();

    /**
     * Gets invoked in case an API request failed.
     * @param errorCodeArray - An {@link ErrorCodeData} array which describes the occurred error.
     */
    void onRequestFailed(ErrorCodeData[] errorCodeArray);

    /**
     * Gets invoked once data was received from the Linode API
     * @param linodeResponse - The {@link LinodeResponse} object which contains the received data.
     */
    void onDataReceived(LinodeResponse linodeResponse);
}
