/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.models.data;
/*
 * This Class was created by Patrick J
 * on 29.02.16. For more Details and licensing information
 * have a look at the README.md
 */

import com.google.gson.annotations.SerializedName;

public class LinodeInfoData {

    @SerializedName("JobID") private int jobId;
    @SerializedName("LinodeID") private int linodeId;
    @SerializedName("ConfigID") private int configId;
    @SerializedName("DiskID") private int diskId;
    @SerializedName("ImageID") private int imageId;
    @SerializedName("IPAddressID") private int ipAddressId;
    @SerializedName("IPAddress") private String ipAddress;
    @SerializedName("HOSTNAME") private String hostName;

    public LinodeInfoData() {}

    public int getJobId() {
        return jobId;
    }

    public int getLinodeId() {
        return linodeId;
    }

    public int getConfigId() {
        return configId;
    }

    public int getDiskId() {
        return diskId;
    }

    public int getImageId() {
        return imageId;
    }

    public int getIpAddressId() {
        return ipAddressId;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public String getHostName() {
        return hostName;
    }
}
