/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.models.data;
/*
 * This Class was created by Patrick J
 * on 29.02.16. For more Details and licensing information
 * have a look at the README.md
 */

import com.google.gson.annotations.SerializedName;

public class LinodeModelData {

    /*
    VALUES WHICH ARE USED BY MULTIPLE API RESPONSES
     */

    @SerializedName("LABEL") private String label;
    @SerializedName("LINODEID") private int linodeId;
    @SerializedName("STATUS") private int status;
    @SerializedName("CREATE_DT") private String creationDate;

    /*
    VALUES RETURNED BY 'linode.list' API CALL
     */

    @SerializedName("TOTALXFER") private int totalXfer;
    @SerializedName("BACKUPSENABLED") private int backupsEnabled;
    @SerializedName("WATCHDOG") private int watchDog;
    @SerializedName("LPM_DISPLAYGROUP") private String lpmDisplayGroup;
    @SerializedName("ALERT_BWQUOTA_ENABLED") private int bwquotaAlertEnabled;
    @SerializedName("TOTALRAM") private int totalRam;
    @SerializedName("ALERT_DISKIO_THRESHOLD") private int diskIoAlertThreshold;
    @SerializedName("BACKUPWINDOW") private int backupWindow;
    @SerializedName("ALERT_BWOUT_ENABLED") private int bwoutAlertEnabled;
    @SerializedName("ALERT_BWOUT_THRESHOLD") private int bwoutAlertThreshold;
    @SerializedName("ALERT_CPU_ENABLED") private int cpuAlertEnabled;
    @SerializedName("ALERT_BWQUOTA_THRESHOLD") private int bwquotaAlertThreshold;
    @SerializedName("ALERT_BWIN_THRESHOLD") private int bwinAlertThreshold;
    @SerializedName("BACKUPWEEKLYDAY") private int weeklyBackupDay;
    @SerializedName("DATACENTERID") private int dataCenterId;
    @SerializedName("ALERT_CPU_THRESHOLD") private int cpuAlertThreshold;
    @SerializedName("TOTALHD") private int totalHd;
    @SerializedName("ALERT_DISKIO_ENABLED") private int diskIoAlertEnabled;
    @SerializedName("ALERT_BWIN_ENABLED") private int bwinAlertEnabled;
    @SerializedName("PLANID") private int planId;
    @SerializedName("DISTRIBUTIONVENDOR") private String distributionVendor;
    @SerializedName("ISXEN") private int isxen;
    @SerializedName("ISKVM") private int iskvm;

    /*
    VALUES RETURNED BY 'linode.config.list' API CALL
     */

    @SerializedName("helper_disableUpdateDB") private int disableDbUpdateHelper;
    @SerializedName("RootDeviceRO") private boolean rootDeviceRo;
    @SerializedName("RootDeviceCustom") private String customRootDevice;
    @SerializedName("DiskList") private String diskList;
    @SerializedName("Comments") private String comments;
    @SerializedName("ConfigID") private int configId;
    @SerializedName("helper_xen") private int xenHelper;
    @SerializedName("RunLevel") private String runLevel;
    @SerializedName("helper_depmod") private int depmodHelper;
    @SerializedName("KernelID") private int kernelId;
    @SerializedName("RootDeviceNum") private int rootDeviceNumber;
    @SerializedName("helper_libtls") private boolean libtlsHelper;
    @SerializedName("RAMLimit") private int ramLimit;

    /*
    VALUES RETURNED BY 'linode.disk.list' API CALL
     */

    @SerializedName("UPDATE_DT") private String updateDate;
    @SerializedName("DISKID") private int diskId;
    @SerializedName("TYPE") private String type;
    @SerializedName("ISREADONLY") private int isReadOnly;
    @SerializedName("SIZE") private int size;

    /*
    VALUES RETURNED BY 'linode.ip.list' API CALL
     */

    @SerializedName("ISPUBLIC") private int isPublic;
    @SerializedName("IPADDRESS") private String ipAddress;
    @SerializedName("RDNS_NAME") private String rdnsName;
    @SerializedName("IPADDRESSID") private int ipAddressId;

    /*
    VALUES RETURNED BY 'linode.job.list' API CALL
     */
    @SerializedName("ENTERED_DT") private String dateEntered;
    @SerializedName("ACTION") private String action;
    @SerializedName("HOST_START_DT") private String hostStartDate;
    @SerializedName("HOST_FINISH_DT") private String hostFinishDate;
    @SerializedName("DURATION") private int duration;
    @SerializedName("HOST_MESSAGE") private String hostMessage;
    @SerializedName("JOBID") private int jobId;
    @SerializedName("HOST_SUCCESS") private int hostSuccess;

    public LinodeModelData() {}

    public String getLabel() {
        return label;
    }

    public int getLinodeId() {
        return linodeId;
    }

    public int getStatus() {
        return status;
    }

    public String getCreationDate() {
        return creationDate;
    }

    public int getTotalXfer() {
        return totalXfer;
    }

    public int getBackupsEnabled() {
        return backupsEnabled;
    }

    public int getWatchDog() {
        return watchDog;
    }

    public String getLpmDisplayGroup() {
        return lpmDisplayGroup;
    }

    public int getBwquotaAlertEnabled() {
        return bwquotaAlertEnabled;
    }

    public int getTotalRam() {
        return totalRam;
    }

    public int getDiskIoAlertThreshold() {
        return diskIoAlertThreshold;
    }

    public int getBackupWindow() {
        return backupWindow;
    }

    public int getBwoutAlertEnabled() {
        return bwoutAlertEnabled;
    }

    public int getBwoutAlertThreshold() {
        return bwoutAlertThreshold;
    }

    public int getCpuAlertEnabled() {
        return cpuAlertEnabled;
    }

    public int getBwquotaAlertThreshold() {
        return bwquotaAlertThreshold;
    }

    public int getBwinAlertThreshold() {
        return bwinAlertThreshold;
    }

    public int getWeeklyBackupDay() {
        return weeklyBackupDay;
    }

    public int getDataCenterId() {
        return dataCenterId;
    }

    public int getCpuAlertThreshold() {
        return cpuAlertThreshold;
    }

    public int getTotalHd() {
        return totalHd;
    }

    public int getDiskIoAlertEnabled() {
        return diskIoAlertEnabled;
    }

    public int getBwinAlertEnabled() {
        return bwinAlertEnabled;
    }

    public int getPlanId() {
        return planId;
    }

    public String getDistributionVendor() {
        return distributionVendor;
    }

    public int getIsxen() {
        return isxen;
    }

    public int getIskvm() {
        return iskvm;
    }

    public int getDisableDbUpdateHelper() {
        return disableDbUpdateHelper;
    }

    public boolean isRootDeviceRo() {
        return rootDeviceRo;
    }

    public String getCustomRootDevice() {
        return customRootDevice;
    }

    public String getDiskList() {
        return diskList;
    }

    public String getComments() {
        return comments;
    }

    public int getConfigId() {
        return configId;
    }

    public int getXenHelper() {
        return xenHelper;
    }

    public String getRunLevel() {
        return runLevel;
    }

    public int getDepmodHelper() {
        return depmodHelper;
    }

    public int getKernelId() {
        return kernelId;
    }

    public int getRootDeviceNumber() {
        return rootDeviceNumber;
    }

    public boolean isLibtlsHelper() {
        return libtlsHelper;
    }

    public int getRamLimit() {
        return ramLimit;
    }

    public String getUpdateDate() {
        return updateDate;
    }

    public int getDiskId() {
        return diskId;
    }

    public String getType() {
        return type;
    }

    public int getIsReadOnly() {
        return isReadOnly;
    }

    public int getSize() {
        return size;
    }

    public int getIsPublic() {
        return isPublic;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public String getRdnsName() {
        return rdnsName;
    }

    public int getIpAddressId() {
        return ipAddressId;
    }

    public String getDateEntered() {
        return dateEntered;
    }

    public String getAction() {
        return action;
    }

    public String getHostStartDate() {
        return hostStartDate;
    }

    public String getHostFinishDate() {
        return hostFinishDate;
    }

    public int getDuration() {
        return duration;
    }

    public String getHostMessage() {
        return hostMessage;
    }

    public int getJobId() {
        return jobId;
    }

    public int getHostSuccess() {
        return hostSuccess;
    }
}
