/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.models.data;
/*
 * This Class was created by Patrick J
 * on 29.02.16. For more Details and licensing information
 * have a look at the README.md
 */

import com.google.gson.annotations.SerializedName;

public class NodeBalancerInfoData {

    @SerializedName("NODEBALANCERID") private int nodeBalancerId;
    @SerializedName("LABEL") private String label;
    @SerializedName("DATACENTERID") private int dataCenterId;
    @SerializedName("HOSTNAME") private String hostName;
    @SerializedName("ADDRESS4") private String ipV4Address;
    @SerializedName("ADDRESS6") private String ipV6Address;
    @SerializedName("CLIENTCONNTHROTTLE") private int clientConnectionThrottle;
    @SerializedName("ConfigID") private int configId;
    @SerializedName("NodeID") private int nodeId;

    /*
    VALUES USED BY 'nodebalancer.config.list' API CALLS
     */

    @SerializedName("STICKINESS") private String stickiness;
    @SerializedName("CHECK_PATH") private String checkPath;
    @SerializedName("PORT") private int port;
    @SerializedName("CHECK_BODY") private String checkBody;
    @SerializedName("CHECK") private String check;
    @SerializedName("CHECK_INTERVAL") private int checkInterval;
    @SerializedName("PROTOCOL") private String protocol;
    @SerializedName("ALGORITHM") private String algorithm;
    @SerializedName("CHECK_TIMEOUT") private int checkTimeout;
    @SerializedName("CHECK_ATTEMPTS") private int checkAttemps;
    @SerializedName("CHECK_PASSIVE") private int checkPassive;
    @SerializedName("SSL_FINGERPRINT") private String sslFingerprint;
    @SerializedName("SSL_COMMONNAME") private String sslCommonName;

    /*
    VALUES USED BY 'nodebalancer.node.list API CALLS
     */

    @SerializedName("WEIGHT") private int weight;
    @SerializedName("ADDRESS") private String address;
    @SerializedName("MODE") private String mode;
    @SerializedName("STATUS") private String status;

    public NodeBalancerInfoData() {}

    public int getNodeBalancerId() {
        return nodeBalancerId;
    }

    public String getLabel() {
        return label;
    }

    public int getDataCenterId() {
        return dataCenterId;
    }

    public String getHostName() {
        return hostName;
    }

    public String getIpV4Address() {
        return ipV4Address;
    }

    public String getIpV6Address() {
        return ipV6Address;
    }

    public int getClientConnectionThrottle() {
        return clientConnectionThrottle;
    }

    public int getConfigId() {
        return configId;
    }

    public int getNodeId() {
        return nodeId;
    }

    public String getStickiness() {
        return stickiness;
    }

    public String getCheckPath() {
        return checkPath;
    }

    public int getPort() {
        return port;
    }

    public String getCheckBody() {
        return checkBody;
    }

    public String getCheck() {
        return check;
    }

    public int getCheckInterval() {
        return checkInterval;
    }

    public String getProtocol() {
        return protocol;
    }

    public String getAlgorithm() {
        return algorithm;
    }

    public int getCheckTimeout() {
        return checkTimeout;
    }

    public int getCheckAttemps() {
        return checkAttemps;
    }

    public int getCheckPassive() {
        return checkPassive;
    }

    public String getSslFingerprint() {
        return sslFingerprint;
    }

    public String getSslCommonName() {
        return sslCommonName;
    }

    public int getWeight() {
        return weight;
    }

    public String getAddress() {
        return address;
    }

    public String getMode() {
        return mode;
    }

    public String getStatus() {
        return status;
    }
}
