/*
 *
 *     Copyright (c) 2016 Patrick J
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */

package com.pddstudio.linodeapi.utils;
/*
 * This Class was created by Patrick J
 * on 28.02.16. For more Details and licensing information
 * have a look at the README.md
 */

import android.content.Context;

import com.pddstudio.linodeapi.config.Config;
import com.pddstudio.linodeapi.config.LinodePreferences;
import com.pddstudio.linodeapi.interfaces.ApiAction;

public final class UrlBuilder {

    private final String baseUrl;
    private final String apiKey;
    private final String apiAction;
    private final StringBuilder customParams;

    public UrlBuilder(Context context, ApiAction apiAction) {
        this.baseUrl = Config.API_URL;
        this.apiKey = LinodePreferences.getInstance(context).getCurrentApiKey();
        this.apiAction = apiAction.getApiCommand();
        this.customParams = new StringBuilder();
    }

    public UrlBuilder appendCustom(String action, String value) {
        this.customParams.append("&").append(action).append("=").append(value);
        return this;
    }

    public String build() {
        return baseUrl + Config.PARAM_PREFIX_API_KEY + apiKey + Config.PARAM_PREFIX_API_ACTION + apiAction;
    }

    public String buildWithCustomParams() {
        String url = build();
        if(!customParams.toString().isEmpty()) url = url + customParams.toString();
        return url;
    }

}
