/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.linodeapi;

import android.content.Context;
import com.pddstudio.linodeapi.LinodeLogin;
import com.pddstudio.linodeapi.LinodeRequest;
import com.pddstudio.linodeapi.LinodeUser;
import com.pddstudio.linodeapi.config.LinodePreferences;
import com.pddstudio.linodeapi.enums.ValidationType;
import com.pddstudio.linodeapi.interfaces.LinodeValidationCallback;
import com.pddstudio.linodeapi.internal.ApiAccessValidation;
import com.pddstudio.linodeapi.utils.Logger;
import io.paperdb.Paper;
import java.util.LinkedList;
import java.util.List;

public final class LinodeApi {
    private static final String LINODE_USERS = "linodeUserObj";
    private static LinodeApi linodeApi;
    private final Context context;
    private final LinodePreferences linodePreferences;
    private final LinodeValidationCallback linodeValidationCallback;

    private LinodeApi(Context context, LinodeValidationCallback linodeValidationCallback) {
        Paper.init((Context)context);
        this.context = context;
        this.linodeValidationCallback = linodeValidationCallback;
        this.linodePreferences = LinodePreferences.getInstance(context);
        this.validateCredentials();
    }

    private void validateCredentials() {
        if (this.linodePreferences.isApiKeyAvailable() || this.linodePreferences.isUsernameAvailable() && this.linodePreferences.isPasswordAvailable()) {
            new ApiAccessValidation(this.linodeValidationCallback, this.linodePreferences).validate();
        } else {
            Logger.log(this, "No API-Key / Credentials available. Skipping validation.");
            this.linodeValidationCallback.onValidationFinished(ValidationType.SKIPPED);
        }
    }

    public static void init(Context context, LinodeValidationCallback linodeValidationCallback) {
        if (linodeApi == null) {
            linodeApi = new LinodeApi(context, linodeValidationCallback);
        }
    }

    public static LinodeApi getInstance() {
        if (linodeApi == null) {
            throw new RuntimeException("Instance not found. Did you forget to initialize LinodeApi?");
        }
        return linodeApi;
    }

    public LinodePreferences getPreferences() {
        return this.linodePreferences;
    }

    public Context getContext() {
        return this.context;
    }

    public void requestApiKey(LinodeLogin.Callback loginCallback, String username, String password) {
        new LinodeLogin(username, password).setCallback(loginCallback).requestApiKey();
    }

    public void requestApiKey(LinodeLogin.Callback loginCallback, String username, String password, String token) {
        new LinodeLogin(username, password).withToken(token).setCallback(loginCallback).requestApiKey();
    }

    public LinodeRequest.Builder newRequest() {
        return new LinodeRequest.Builder(this.context);
    }

    public void saveLinodeUser(LinodeUser linodeUser) {
        LinkedList users = (LinkedList)Paper.book().read(LINODE_USERS, new LinkedList());
        for (int i = 0; i < users.size(); ++i) {
            LinodeUser user = (LinodeUser)users.get(i);
            if (!user.getUsername().toLowerCase().equals(linodeUser.getUsername().toLowerCase())) continue;
            users.remove(i);
        }
        users.add(linodeUser);
        Paper.book().write(LINODE_USERS, (Object)users);
    }

    public List<LinodeUser> getLinodeUsers() {
        return (List)Paper.book().read(LINODE_USERS, new LinkedList());
    }

    public void switchAccount(LinodeUser linodeUser) {
        this.linodePreferences.setCurrentUsername(linodeUser.getUsername());
        this.linodePreferences.setCurrentPassword(linodeUser.getPassword());
        this.linodePreferences.setCurrentApiKey(linodeUser.getToken());
    }
}

