/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.linodeapi;

import com.pddstudio.linodeapi.LinodeUser;
import com.pddstudio.linodeapi.async.AsyncLoginTask;
import com.pddstudio.linodeapi.models.data.ErrorCodeData;

public class LinodeLogin {
    private final String username;
    private final String password;
    private String token;
    private Callback callback;

    protected LinodeLogin(String username, String password) {
        this.username = username;
        this.password = password;
    }

    protected LinodeLogin withToken(String token) {
        this.token = token;
        return this;
    }

    protected LinodeLogin setCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    private void validate() {
        if (this.username == null || this.username.isEmpty() || this.password == null || this.password.isEmpty() || this.callback == null) {
            throw new RuntimeException("LinodeLogin is missing Username, Password (must not be null or empty) or Callback interface!");
        }
    }

    public void requestApiKey() {
        this.validate();
        AsyncLoginTask asyncLoginTask = new AsyncLoginTask(this);
        asyncLoginTask.execute(new Void[0]);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean withToken() {
        return this.token != null;
    }

    public String getToken() {
        return this.token;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public static interface Callback {
        public void onLoginSuccess(LinodeUser var1);

        public void onLoginFailed(ErrorCodeData[] var1);
    }
}

