/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.linodeapi;

import android.content.Context;
import com.pddstudio.linodeapi.async.AsyncApiRequest;
import com.pddstudio.linodeapi.interfaces.ApiAction;
import com.pddstudio.linodeapi.interfaces.LinodeRequestCallback;
import com.pddstudio.linodeapi.utils.UrlBuilder;

public class LinodeRequest {
    private final Context context;
    private final ApiAction apiAction;
    private final LinodeRequestCallback linodeRequestCallback;
    private final UrlBuilder urlBuilder;

    private LinodeRequest(Builder builder) {
        this.context = builder.context;
        this.apiAction = builder.apiAction;
        this.linodeRequestCallback = builder.linodeRequestCallback;
        this.urlBuilder = builder.urlBuilder;
    }

    public void execute() {
        String apiUrl = this.urlBuilder.buildWithCustomParams();
        AsyncApiRequest asyncApiRequest = new AsyncApiRequest(this.linodeRequestCallback, apiUrl, this.apiAction.getBaseModel());
        asyncApiRequest.execute(new Void[0]);
    }

    public static class Builder {
        private final Context context;
        private ApiAction apiAction;
        private LinodeRequestCallback linodeRequestCallback;
        private UrlBuilder urlBuilder;

        protected Builder(Context context) {
            this.context = context;
        }

        public Builder setApiAction(ApiAction apiAction) {
            this.apiAction = apiAction;
            this.urlBuilder = new UrlBuilder(this.context, apiAction);
            return this;
        }

        public Builder addCustomApiParams(String action, String value) {
            if (this.urlBuilder != null && action != null && !action.isEmpty() && value != null && !value.isEmpty()) {
                this.urlBuilder.appendCustom(action, value);
            }
            return this;
        }

        public Builder setRequestCallback(LinodeRequestCallback linodeRequestCallback) {
            this.linodeRequestCallback = linodeRequestCallback;
            return this;
        }

        public LinodeRequest build() {
            return new LinodeRequest(this);
        }

        public void execute() {
            LinodeRequest linodeRequest = new LinodeRequest(this);
            linodeRequest.execute();
        }
    }
}

