/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.linodeapi;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.pddstudio.linodeapi.utils.MD5Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class LinodeUser {
    private String username;
    private String password;
    private String token;

    public LinodeUser() {
    }

    public LinodeUser(String username, String password, String token) {
        this.username = username;
        this.password = password;
        this.token = token;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getProfileImageUrl() {
        String hexAcc = MD5Utils.md5Hex(this.username);
        return "http://www.gravatar.com/avatar/" + hexAcc + ".jpg";
    }

    public String getProfileImageUrl(int profileImageSizePx) {
        String hexAcc = MD5Utils.md5Hex(this.username);
        return "http://www.gravatar.com/avatar/" + hexAcc + ".jpg?s=" + profileImageSizePx;
    }

    public Bitmap getProfileImage() {
        try {
            URL url = new URL(this.getProfileImageUrl());
            URLConnection conn = url.openConnection();
            conn.connect();
            BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
            Bitmap bm = BitmapFactory.decodeStream((InputStream)bis);
            bis.close();
            return bm;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Bitmap getProfileImage(int profileImageSizePx) {
        try {
            URL url = new URL(this.getProfileImageUrl(profileImageSizePx));
            URLConnection conn = url.openConnection();
            conn.connect();
            BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
            Bitmap bm = BitmapFactory.decodeStream((InputStream)bis);
            bis.close();
            return bm;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

