/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.linodeapi.async;

import android.os.AsyncTask;
import com.google.gson.Gson;
import com.pddstudio.linodeapi.LinodeResponse;
import com.pddstudio.linodeapi.abstracts.BaseModel;
import com.pddstudio.linodeapi.interfaces.LinodeRequestCallback;
import com.pddstudio.linodeapi.utils.Logger;
import com.pddstudio.linodeapi.utils.TypeUtils;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class AsyncApiRequest
extends AsyncTask<Void, Void, Object> {
    private final LinodeRequestCallback linodeRequestCallback;
    private final String apiCallUrl;
    private final BaseModel baseModel;

    public AsyncApiRequest(LinodeRequestCallback linodeRequestCallback, String apiCallUrl, BaseModel baseModel) {
        this.linodeRequestCallback = linodeRequestCallback;
        this.apiCallUrl = apiCallUrl;
        this.baseModel = baseModel;
    }

    public void onPreExecute() {
        this.linodeRequestCallback.onRequestStarted();
    }

    protected Object doInBackground(Void ... params) {
        OkHttpClient okHttpClient = new OkHttpClient();
        Gson gson = new Gson();
        Logger.log((Object)this, "Building and executing request for given URL: " + this.apiCallUrl);
        try {
            Object responseData;
            Request request = new Request.Builder().url(this.apiCallUrl).build();
            Response response = okHttpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                this.cancel(true);
            }
            if ((responseData = gson.fromJson(response.body().charStream(), this.baseModel.getModelClass())) != null) {
                return responseData;
            }
        }
        catch (IOException io) {
            Logger.log((Object)this, "API call execution failed! Reason:\n" + io.getMessage());
            this.cancel(true);
        }
        return null;
    }

    protected void onCancelled() {
        Logger.log((Object)this, "AsyncApiRequest cancelled. This might happen by an exception or in case the response wasn't parseable.");
        this.linodeRequestCallback.onRequestFailed(null);
    }

    public void onPostExecute(Object responseData) {
        boolean dataExist = responseData != null;
        Logger.log((Object)this, "API Request executed. Checking if response object is filled with data: " + dataExist);
        LinodeResponse linodeResponse = new LinodeResponse(this.baseModel.getModelClass());
        linodeResponse.setResponse(TypeUtils.convertType(responseData, this.baseModel.getClass()));
        this.linodeRequestCallback.onDataReceived(linodeResponse);
    }
}

