/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.linodeapi.async;

import android.os.AsyncTask;
import com.google.gson.Gson;
import com.pddstudio.linodeapi.LinodeApi;
import com.pddstudio.linodeapi.LinodeLogin;
import com.pddstudio.linodeapi.LinodeUser;
import com.pddstudio.linodeapi.config.LinodePreferences;
import com.pddstudio.linodeapi.models.UserInfo;
import com.pddstudio.linodeapi.models.data.UserApiKeyData;
import com.pddstudio.linodeapi.utils.Logger;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class AsyncLoginTask
extends AsyncTask<Void, Void, UserInfo> {
    private final String requestUrl;
    private final LinodeLogin linodeLogin;
    private final LinodePreferences linodePreferences;
    private final String username;
    private final String password;
    private final String token;

    public AsyncLoginTask(LinodeLogin linodeLogin) {
        this.requestUrl = "https://api.linode.com/?api_action=user.getapikey&username=" + linodeLogin.getUsername() + "&password=" + linodeLogin.getPassword() + (linodeLogin.withToken() ? "&token=" + linodeLogin.getToken() : "") + "&expires=0&label=LINODE_ANDROID_API_KEY";
        this.linodeLogin = linodeLogin;
        this.linodePreferences = LinodePreferences.getInstance(LinodeApi.getInstance().getContext());
        this.username = linodeLogin.getUsername();
        this.password = linodeLogin.getPassword();
        this.token = linodeLogin.getToken();
    }

    protected UserInfo doInBackground(Void ... params) {
        Gson gson = new Gson();
        OkHttpClient okHttpClient = new OkHttpClient();
        Logger.log((Object)this, "Building and executing request for given URL: " + this.requestUrl);
        try {
            UserInfo userInfo;
            Request request = new Request.Builder().url(this.requestUrl).build();
            Response response = okHttpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                this.cancel(true);
            }
            if ((userInfo = (UserInfo)gson.fromJson(response.body().charStream(), UserInfo.class)) != null) {
                return userInfo;
            }
        }
        catch (IOException io) {
            Logger.log((Object)this, "API call execution failed! Reason:\n" + io.getMessage());
            this.cancel(true);
        }
        return null;
    }

    public void onPostExecute(UserInfo userInfo) {
        if (userInfo != null) {
            if (userInfo.getErrorCodeArray().length > 0) {
                this.linodeLogin.getCallback().onLoginFailed(userInfo.getErrorCodeArray());
            } else {
                String apiKey = ((UserApiKeyData)userInfo.getResponseData()).getApiKey();
                Logger.log((Object)this, "API-Key received successfully [" + apiKey + "]");
                this.linodePreferences.setCurrentApiKey(apiKey);
                this.linodePreferences.setCurrentUsername(this.username);
                this.linodePreferences.setCurrentPassword(this.password);
                this.linodeLogin.getCallback().onLoginSuccess(new LinodeUser(this.username, this.password, apiKey));
            }
        }
    }
}

