/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.linodeapi.config;

import android.content.Context;
import android.content.SharedPreferences;
import com.pddstudio.linodeapi.utils.Logger;

public final class LinodePreferences {
    private static final String PREFERENCES_NAME = "LinodePreferences";
    private static final String CURRENT_API_KEY = "currentApiKey";
    private static final String CURRENT_USERNAME = "currentUserName";
    private static final String CURRENT_PASSWORD = "currentUserPwd";
    private static final String CURRENT_TOKEN = "currentUserToken";
    private static final String USE_TOKEN_AUTH = "tokenAuthEnabled";
    private static LinodePreferences linodePreferences;
    private final Context context;
    private final SharedPreferences sharedPreferences;

    private LinodePreferences(Context context) {
        this.context = context;
        this.sharedPreferences = context.getSharedPreferences(this.buildPreferenceName(), 0);
        Logger.log(this, "LinodePreferences instance created.");
    }

    public static LinodePreferences getInstance(Context context) {
        if (linodePreferences == null) {
            linodePreferences = new LinodePreferences(context);
        }
        return linodePreferences;
    }

    private String buildPreferenceName() {
        String prefName = this.context.getPackageName() + "." + PREFERENCES_NAME;
        Logger.log(this, "buildPreferenceName() returned -> " + prefName);
        return prefName;
    }

    public void setCurrentApiKey(String apiKey) {
        if (apiKey != null && !apiKey.isEmpty()) {
            this.sharedPreferences.edit().putString(CURRENT_API_KEY, apiKey).apply();
        } else {
            Logger.log(this, "Warning: Can't update current api key, the given value must not be null or empty!");
        }
    }

    public String getCurrentApiKey() {
        return this.sharedPreferences.getString(CURRENT_API_KEY, null);
    }

    public boolean isApiKeyAvailable() {
        String key = this.sharedPreferences.getString(CURRENT_API_KEY, null);
        return key != null && !key.isEmpty();
    }

    public void setCurrentUsername(String username) {
        if (username != null && !username.isEmpty()) {
            this.sharedPreferences.edit().putString(CURRENT_USERNAME, username).apply();
        } else {
            Logger.log(this, "Warning: Can't update username, the given value must not be null or empty!");
        }
    }

    public String getCurrentUsername() {
        return this.sharedPreferences.getString(CURRENT_USERNAME, null);
    }

    public boolean isUsernameAvailable() {
        String key = this.sharedPreferences.getString(CURRENT_USERNAME, null);
        return key != null && !key.isEmpty();
    }

    public void setCurrentPassword(String password) {
        if (password != null && !password.isEmpty()) {
            this.sharedPreferences.edit().putString(CURRENT_PASSWORD, password).apply();
        } else {
            Logger.log(this, "Warning: Can't update password, the given value must not be null or empty!");
        }
    }

    public String getCurrentPassword() {
        return this.sharedPreferences.getString(CURRENT_PASSWORD, null);
    }

    public boolean isPasswordAvailable() {
        String key = this.sharedPreferences.getString(CURRENT_PASSWORD, null);
        return key != null && !key.isEmpty();
    }
}

